/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum TotemProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag tag;
        if (blockAccessor.getServerData().m_128425_("totem", 10) && (tag = blockAccessor.getServerData().m_128469_("totem")).m_128441_("controllingFaction")) {
            IFaction capturing;
            IFaction controlling = tag.m_128441_("controllingFaction") ? VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(tag.m_128461_("controllingFaction"))) : null;
            IFaction iFaction = capturing = tag.m_128441_("capturingFaction") ? VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(tag.m_128461_("capturingFaction"))) : null;
            if (capturing != null) {
                if (controlling != null) {
                    iTooltip.add((Component)Component.m_237115_((String)"text.vampirism_integrations.defending").m_130946_(": ").m_7220_((Component)controlling.getNamePlural().m_6879_().m_130938_(s -> s.m_131148_(controlling.getChatColor()))));
                }
                iTooltip.add((Component)Component.m_237115_((String)"text.vampirism_integrations.attacking").m_130946_(": ").m_7220_((Component)capturing.getNamePlural().m_6879_().m_130938_(s -> s.m_131148_(capturing.getChatColor()))));
            } else if (controlling != null) {
                iTooltip.add((Component)Component.m_237115_((String)"text.vampirism_integrations.controlling").m_130946_(": ").m_7220_((Component)controlling.getNamePlural().m_6879_().m_130938_(s -> s.m_131148_(controlling.getChatColor()))));
            }
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof TotemBlockEntity) {
            TotemBlockEntity totem = (TotemBlockEntity)blockEntity;
            CompoundTag compoundTag = new CompoundTag();
            Optional.ofNullable(totem.getControllingFaction()).map(IFaction::getID).ifPresent(id -> compoundTag.m_128359_("controllingFaction", id.toString()));
            Optional.ofNullable(totem.getCapturingFaction()).map(IFaction::getID).ifPresent(id -> compoundTag.m_128359_("capturingFaction", id.toString()));
            tag.m_128365_("totem", (Tag)compoundTag);
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.TOTEM;
    }
}

