/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca.client;

import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Genetics;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class LayerVampireFace<T extends Mob>
extends VillagerLayer<T, VillagerEntityModelMCA<T>> {
    private final ResourceLocation[] eyeOverlays = new ResourceLocation[16];
    private final ResourceLocation[] fangOverlays;

    public LayerVampireFace(RenderLayerParent<T, VillagerEntityModelMCA<T>> renderer, VillagerEntityModelMCA<T> model) {
        super(renderer, model);
        int i;
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[7];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public ResourceLocation getSkin(T villager) {
        int totalFaces = this.eyeOverlays.length;
        int index = (int)Math.min((float)(totalFaces - 1), Math.max(0.0f, ((VillagerLike)villager).getGenetics().getGene(Genetics.FACE) * (float)totalFaces));
        return this.eyeOverlays[index];
    }

    protected ResourceLocation getOverlay(T villager) {
        int totalFangs = this.fangOverlays.length;
        int index = (int)Math.min((float)(totalFangs - 1), Math.max(0.0f, ((VillagerLike)villager).getGenetics().getGene(Genetics.FACE) * (float)totalFangs));
        return this.fangOverlays[index];
    }
}

