/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;

public class AutoVolumeControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:auto_volume");
    boolean autoVol;

    public AutoVolumeControl(boolean autoVol) {
        super(id);
        this.autoVol = autoVol;
    }

    public AutoVolumeControl(FriendlyByteBuf buf) {
        super(id);
        this.autoVol = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.autoVol);
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        this.checkPerms(16, permissionChecker, ctx.getSender());
        tes.setAutoVolume(side, this.autoVol);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        tes.setAutoVolume(side, this.autoVol);
    }
}

