/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities.browser.handlers.js.queries;

import com.google.gson.JsonObject;
import net.montoyo.wd.utilities.browser.handlers.js.JSQueryHandler;
import net.montoyo.wd.utilities.browser.handlers.js.Scripts;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefQueryCallback;

public class ElementCenterQuery
extends JSQueryHandler {
    boolean exists = false;
    double x;
    double y;
    JsonObject obj;
    long start = -1L;
    String extra = "";
    String elementName;
    String script = null;

    public ElementCenterQuery(String queryName, String name) {
        super(queryName);
        this.elementName = name;
    }

    public ElementCenterQuery addAdditional(String key, String value) {
        this.extra = this.extra + "'," + key + ":' + " + value + " +";
        this.script = null;
        return this;
    }

    @Override
    public boolean handle(CefBrowser browser, CefFrame frame, JsonObject data, boolean persistent, CefQueryCallback callback) {
        this.exists = data.getAsJsonPrimitive("exists").getAsBoolean();
        if (this.exists) {
            this.x = data.getAsJsonPrimitive("x").getAsDouble() + data.getAsJsonPrimitive("w").getAsDouble() / 2.0;
            this.y = data.getAsJsonPrimitive("y").getAsDouble() + data.getAsJsonPrimitive("h").getAsDouble() / 2.0;
        }
        this.obj = data;
        this.start = -1L;
        callback.success("Success");
        return true;
    }

    public void dispatch(CefBrowser browser) {
        if (this.script == null) {
            this.script = Scripts.QUERY_ELEMENT.replace("%type%", this.elementName).replace("%Type%", this.name).replace("%extra%", this.extra);
        }
        if (this.start == -1L) {
            browser.executeJavaScript(this.script, "CenterQuery", 0);
            this.start = System.currentTimeMillis();
        } else {
            long ms = System.currentTimeMillis();
            if (this.start + 1000L < ms) {
                browser.executeJavaScript(this.script, "CenterQuery", 0);
                this.start = System.currentTimeMillis();
            }
        }
    }

    public boolean hasFocused() {
        return this.exists;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public JsonObject getObj() {
        return this.obj;
    }
}

