/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities.serialization;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.montoyo.wd.utilities.serialization.DontSerialize;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public abstract class Util {
    public static final String[] SIZES = new String[]{"bytes", "KiB", "MiB", "GiB", "TiB"};

    @Deprecated(forRemoval=true)
    public static void serialize(FriendlyByteBuf bb, Object f) {
        Class<?> cls = f.getClass();
        if (cls == Integer.class || cls == Integer.TYPE) {
            bb.writeInt(((Integer)f).intValue());
        } else if (cls == Float.class || cls == Float.TYPE) {
            bb.writeFloat(((Float)f).floatValue());
        } else if (cls == Double.class || cls == Double.TYPE) {
            bb.writeDouble(((Double)f).doubleValue());
        } else if (cls == Boolean.class || cls == Boolean.TYPE) {
            bb.writeBoolean(((Boolean)f).booleanValue());
        } else if (cls == String.class) {
            bb.m_130070_((String)f);
        } else if (cls == NameUUIDPair.class) {
            ((NameUUIDPair)f).writeTo(bb);
        } else if (cls.isEnum()) {
            bb.writeByte(((Enum)f).ordinal());
        } else if (cls.isArray()) {
            Object[] ray = (Object[])f;
            bb.writeInt(ray.length);
            for (Object o : ray) {
                Util.serialize(bb, o);
            }
        } else if (cls == ResourceLocation.class) {
            bb.m_130070_(f.toString());
        } else if (!cls.isPrimitive()) {
            Field[] fields;
            for (Field ff : fields = cls.getFields()) {
                try {
                    if (ff.getAnnotation(DontSerialize.class) != null || Modifier.isStatic(ff.getModifiers())) continue;
                    Util.serialize(bb, ff.get(f));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(String.format("Caught IllegalAccessException for %s.%s", cls.getName(), ff.getName()));
                }
            }
        } else {
            throw new RuntimeException(String.format("Cannot transmit class %s over network!", cls.getName()));
        }
    }

    @Deprecated(forRemoval=true)
    public static Object unserialize(FriendlyByteBuf bb, Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return bb.readInt();
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.valueOf(bb.readFloat());
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return bb.readDouble();
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return bb.readBoolean();
        }
        if (cls == String.class) {
            return bb.m_130277_();
        }
        if (cls == NameUUIDPair.class) {
            return new NameUUIDPair(bb);
        }
        if (cls.isEnum()) {
            return cls.getEnumConstants()[bb.readByte()];
        }
        if (cls.isArray()) {
            Object[] ray = new Object[bb.readInt()];
            for (int i = 0; i < ray.length; ++i) {
                ray[i] = Util.unserialize(bb, cls.getComponentType());
            }
            return Arrays.copyOf(ray, ray.length, cls);
        }
        if (cls == ResourceLocation.class) {
            return new ResourceLocation(bb.m_130277_());
        }
        if (!cls.isPrimitive()) {
            Object ret;
            Field[] fields = cls.getFields();
            try {
                ret = cls.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException(String.format("Caught InstantiationException for class %s", cls.getName()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(String.format("Caught IllegalAccessException for class %s", cls.getName()));
            }
            for (Field ff : fields) {
                try {
                    if (ff.getAnnotation(DontSerialize.class) != null || Modifier.isStatic(ff.getModifiers())) continue;
                    ff.set(ret, Util.unserialize(bb, ff.getType()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Caught IllegalAccessException for %s.%s", cls.getName(), ff.getName()));
                }
            }
            return ret;
        }
        throw new RuntimeException(String.format("Cannot unserialize class %s!", cls.getName()));
    }

    public static String addSlashes(String str) {
        Object out = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            out = c == '\\' ? (String)out + "\\\\" : (c == '\"' ? (String)out + "\\\"" : (String)out + c);
        }
        return out;
    }

    public static int scrambleKey(int idx) {
        return (idx *= -1640531527) ^ idx >> 16;
    }

    public static void toast(Player player, String key, Object ... data) {
        Util.toast(player, ChatFormatting.RED, key, data);
    }

    public static void toast(Player player, ChatFormatting color, String key, Object ... data) {
        MutableComponent root = Component.m_237115_((String)"[WebDisplays] ").m_6270_(Style.f_131099_.m_131140_(color)).m_7220_((Component)Component.m_237110_((String)("webdisplays.message." + key), (Object[])data));
        player.m_213846_((Component)root);
    }

    public static void silentClose(Object obj) {
        try {
            obj.getClass().getMethod("close", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String addProtocol(String str) {
        return str.isEmpty() || str.contains("://") ? str : "http://" + str;
    }

    public static boolean isFileNameInvalid(String fname) {
        return fname.isEmpty() || fname.length() > 64 || fname.charAt(0) == '.' || fname.indexOf(47) >= 0 || fname.indexOf(92) >= 0;
    }

    public static String sizeString(long l) {
        double d = l;
        int size = 0;
        while (l >= 1024L && size + 1 < SIZES.length) {
            d /= 1024.0;
            l /= 1024L;
            ++size;
        }
        return String.format("%.2f %s", d, SIZES[size]);
    }

    public static String join(String[] array, String sep) {
        StringJoiner j = new StringJoiner(sep);
        Arrays.stream(array).forEach(j::add);
        return j.toString();
    }

    public static CompoundTag writeOwnerToNBT(CompoundTag tag, NameUUIDPair owner) {
        if (owner != null) {
            tag.m_128356_("OwnerMSB", owner.uuid.getMostSignificantBits());
            tag.m_128356_("OwnerLSB", owner.uuid.getLeastSignificantBits());
            tag.m_128359_("OwnerName", owner.name);
        }
        return tag;
    }

    public static NameUUIDPair readOwnerFromNBT(CompoundTag tag) {
        long msb = tag.m_128454_("OwnerMSB");
        long lsb = tag.m_128454_("OwnerLSB");
        String str = tag.m_128461_("OwnerName");
        return new NameUUIDPair(str, new UUID(msb, lsb));
    }
}

