/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.base.Predicates;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.SwineherdEntity;
import com.talhanation.workers.entities.ai.AnimalFarmerAI;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.Items;

public class SwineherdAI
extends AnimalFarmerAI {
    private Optional<Pig> pig;
    private boolean breeding;
    private boolean slaughtering;
    private BlockPos workPos;

    public SwineherdAI(SwineherdEntity worker) {
        this.animalFarmer = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.animalFarmer.getStatus() == AbstractWorkerEntity.Status.WORK;
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.animalFarmer.getStartPos();
        this.breeding = true;
        this.slaughtering = false;
    }

    @Override
    public void performWork() {
        if (!this.workPos.m_123314_((Vec3i)this.animalFarmer.m_20097_(), 10.0) && this.workPos != null) {
            this.animalFarmer.m_21573_().m_26519_((double)this.workPos.m_123341_(), (double)this.workPos.m_123342_(), (double)this.workPos.m_123343_(), 1.0);
        }
        if (this.breeding) {
            this.pig = this.findPigBreeding();
            if (this.pig.isPresent()) {
                int i = this.pig.get().m_146764_();
                if (i == 0 && this.hasBreedItem(Items.f_42619_)) {
                    this.animalFarmer.m_21573_().m_5624_((Entity)this.pig.get(), 1.0);
                    this.animalFarmer.changeToBreedItem(Items.f_42619_);
                    if (this.pig.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                        this.animalFarmer.workerSwingArm();
                        this.consumeBreedItem(Items.f_42619_);
                        this.animalFarmer.m_21563_().m_24950_(this.pig.get().m_20185_(), this.pig.get().m_20188_(), this.pig.get().m_20189_(), 10.0f, (float)this.animalFarmer.m_8132_());
                        this.pig.get().m_27595_(null);
                        this.pig = Optional.empty();
                    }
                } else {
                    this.breeding = false;
                    this.slaughtering = true;
                }
            } else {
                this.breeding = false;
                this.slaughtering = true;
            }
        }
        if (this.slaughtering) {
            List<Pig> cows = this.findPigSlaughtering();
            if (cows.size() > this.animalFarmer.getMaxAnimalCount() && this.animalFarmer.hasMainToolInInv()) {
                this.pig = cows.stream().findFirst();
                if (this.pig.isPresent()) {
                    if (!this.animalFarmer.isRequiredMainTool(this.animalFarmer.m_21205_())) {
                        this.animalFarmer.changeToTool(true);
                    }
                    this.animalFarmer.m_21573_().m_26519_(this.pig.get().m_20185_(), this.pig.get().m_20186_(), this.pig.get().m_20189_(), 1.0);
                    if (this.pig.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                        this.pig.get().m_6074_();
                        this.animalFarmer.workerSwingArm();
                        this.animalFarmer.m_216990_(SoundEvents.f_12316_);
                        this.animalFarmer.consumeToolDurability();
                        this.animalFarmer.increaseFarmedItems();
                    }
                } else {
                    this.slaughtering = false;
                    this.breeding = true;
                }
            } else {
                if (!this.animalFarmer.hasMainToolInInv()) {
                    this.animalFarmer.needsMainTool = true;
                }
                this.slaughtering = false;
                this.breeding = true;
            }
        }
    }

    private Optional<Pig> findPigBreeding() {
        return this.animalFarmer.m_20193_().m_6443_(Pig.class, this.animalFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).findAny();
    }

    private List<Pig> findPigSlaughtering() {
        return this.animalFarmer.m_20193_().m_6443_(Pig.class, this.animalFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).collect(Collectors.toList());
    }
}

