/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai.navigation.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class WorkersDoorInteractGoal
extends Goal {
    protected Mob mob;
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public WorkersDoorInteractGoal(Mob p_25193_) {
        this.mob = p_25193_;
        if (!GoalUtils.m_26894_((Mob)p_25193_)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.mob.m_20193_().m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_);
    }

    protected void setOpen(boolean open) {
        if (this.hasDoor) {
            BlockState blockstate = this.mob.m_20193_().m_8055_(this.doorPos);
            if (blockstate.m_60734_() instanceof DoorBlock) {
                ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.mob, this.mob.m_20193_(), blockstate, this.doorPos, open);
            } else if (blockstate.m_60734_() instanceof FenceGateBlock) {
                this.useGate(blockstate, this.mob.m_20193_(), this.doorPos, (Entity)this.mob);
            }
            for (Direction direction : Direction.values()) {
                if (direction.equals((Object)Direction.DOWN)) continue;
                BlockPos blockPos = this.doorPos.m_121945_(direction);
                BlockState state = this.mob.m_20193_().m_8055_(blockPos);
                if (state.m_60734_() instanceof DoorBlock) {
                    ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.mob, this.mob.m_20193_(), blockstate, this.doorPos, open);
                    continue;
                }
                if (!(state.m_60734_() instanceof FenceGateBlock)) continue;
                this.useGate(blockstate, this.mob.m_20193_(), blockPos, (Entity)this.mob);
            }
        }
    }

    public boolean m_8036_() {
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        if (!this.mob.f_19862_) {
            return false;
        }
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.m_21573_();
        Path path = groundpathnavigation.m_26570_();
        if (path != null && !path.m_77392_() && groundpathnavigation.m_26492_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.doorPos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
                if (this.mob.m_20275_((double)this.doorPos.m_123341_(), this.mob.m_20186_(), (double)this.doorPos.m_123343_()) > 2.25) continue;
                boolean bl = this.hasDoor = DoorBlock.m_52745_((Level)this.mob.m_20193_(), (BlockPos)this.doorPos) || this.mob.m_20193_().m_8055_(this.doorPos).m_60734_() instanceof FenceGateBlock;
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.m_20183_().m_7494_();
            this.hasDoor = DoorBlock.m_52745_((Level)this.mob.m_20193_(), (BlockPos)this.doorPos) || this.mob.m_20193_().m_8055_(this.doorPos).m_60734_() instanceof FenceGateBlock;
            return this.hasDoor;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }

    public void useGate(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.FALSE);
            level.m_7731_(blockPos, blockState, 10);
        } else {
            Direction direction = entity.m_6350_();
            if (blockState.m_61143_((Property)FenceGateBlock.f_54117_) == direction.m_122424_()) {
                blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)direction);
            }
            blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.TRUE);
            level.m_7731_(blockPos, blockState, 10);
        }
        boolean flag = (Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_);
        level.m_142346_(entity, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
    }
}

