/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="wukong", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.DoubleValue DERIVE_CHECK_TIME;
    public static final ForgeConfigSpec.DoubleValue CHARGING_SPEED;
    public static final ForgeConfigSpec.DoubleValue STAFF_FLOWER_STAMINA_CONSUME;
    public static final ForgeConfigSpec.DoubleValue DERIVE_STAMINA_CONSUME;
    public static final ForgeConfigSpec.DoubleValue BASIC_ATTACK_INTERVAL_TICKS;
    public static final ForgeConfigSpec.BooleanValue GET_GUILD_BOOK;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITIES_CAN_BE_BLOCKED_BY_STAFF_FLOWER;
    public static final ForgeConfigSpec SPEC;
    public static Set<? extends EntityType<?>> entities_can_be_blocked;

    private static ForgeConfigSpec.BooleanValue createBool(String key, boolean defaultValue) {
        return BUILDER.translation("config.wukong." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.BooleanValue createBool(String comment, String key, boolean defaultValue) {
        return BUILDER.comment(comment).translation("config.wukong." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.DoubleValue createDouble(String comment, String key, double defaultValue) {
        return BUILDER.comment(comment).translation("config.wukong." + key).defineInRange(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private static boolean validateEntityName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wukong").requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
    }

    private static int setConfig(ForgeConfigSpec.DoubleValue config, double value, CommandSourceStack stack) {
        config.set((Object)value);
        stack.m_288197_(() -> Component.m_237113_((String)("Successfully set to : " + value)), true);
        return 0;
    }

    private static int setConfig(ForgeConfigSpec.BooleanValue config, boolean value, CommandSourceStack stack) {
        config.set((Object)value);
        stack.m_288197_(() -> Component.m_237113_((String)("Successfully set to : " + value)), true);
        return 0;
    }

    static {
        entities_can_be_blocked = new HashSet();
        GET_GUILD_BOOK = Config.createBool("\u7ed9\u7b2c\u4e00\u4e2a\u8fdb\u6e38\u620f\u7684\u73a9\u5bb6\u73a9\u6cd5\u8bf4\u660e\u3002", "get_guild_book", true);
        BASIC_ATTACK_INTERVAL_TICKS = Config.createDouble("\u81ea\u5b9a\u4e49\u666e\u653b\u95f4\u9694\u5224\u5b9a\u65f6\u95f4\uff08\u539f\u7248\u592a\u957f\u4e86\uff01\uff09", "basic_attack_time_interval", 16.0);
        DERIVE_CHECK_TIME = Config.createDouble("\u5207\u624b\u6280\u5224\u5b9a\u65f6\u95f4", "derive_check_time", 30.0);
        CHARGING_SPEED = Config.createDouble("\u84c4\u529b\u65f6\u6bcftick\u589e\u52a0\u7684\u68cd\u52bf\uff08\u5f71\u54cd\u68cd\u52bf\u6d88\u8017\u901f\u5ea6\uff01\uff09", "charging_speed", 1.2);
        STAFF_FLOWER_STAMINA_CONSUME = Config.createDouble("\u68cd\u82b1\u6bcftick\u8010\u529b\u6d88\u8017", "staff_flower_stamina_consume", 0.1);
        DERIVE_STAMINA_CONSUME = Config.createDouble("\u7acb\u68cd\u548c\u6233\u68cd\u5207\u624b\u6280\u6bcftick\u8010\u529b\u6d88\u8017", "derive_stamina_consume", 2.0);
        ENTITIES_CAN_BE_BLOCKED_BY_STAFF_FLOWER = BUILDER.comment("\u53ef\u88ab\u68cd\u82b1\u683c\u6321\u7684\u5b9e\u4f53").defineListAllowEmpty(List.of("\u53ef\u88ab\u68cd\u82b1\u683c\u6321\u7684\u5b9e\u4f53"), () -> List.of("minecraft:arrow"), Config::validateEntityName);
        SPEC = BUILDER.build();
    }
}

