/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.capability;

import com.p1nero.wukong.capability.WKPlayer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="wukong", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WKCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<WKPlayer> WK_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<WKPlayer>(){});
    private WKPlayer wkPlayer = null;
    private final LazyOptional<WKPlayer> optional = LazyOptional.of(this::createWKPlayer);

    private WKPlayer createWKPlayer() {
        if (this.wkPlayer == null) {
            this.wkPlayer = new WKPlayer();
        }
        return this.wkPlayer;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == WK_PLAYER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createWKPlayer().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createWKPlayer().loadNBTData(tag);
    }

    @Mod.EventBusSubscriber(modid="wukong")
    public static class Registration {
        @SubscribeEvent
        public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(WK_PLAYER).isPresent()) {
                event.addCapability(new ResourceLocation("wukong", "wk_player"), (ICapabilityProvider)new WKCapabilityProvider());
            }
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            event.getOriginal().reviveCaps();
            if (event.isWasDeath()) {
                event.getOriginal().getCapability(WK_PLAYER).ifPresent(oldStore -> event.getEntity().getCapability(WK_PLAYER).ifPresent(newStore -> newStore.copyFrom((WKPlayer)oldStore)));
            }
        }

        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(WKPlayer.class);
        }
    }
}

