/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.client.event;

import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;

@Mod.EventBusSubscriber(modid="wukong", value={Dist.CLIENT})
public class CameraAnim {
    public static final Vec3f DEFAULT_AIMING_CORRECTION;
    private static Vec3f AIMING_CORRECTION;
    private static final int zoomMaxCount = 20;
    private static boolean aiming;
    private static int zoomOutTimer;
    private static int zoomCount;

    public static boolean isAiming() {
        return aiming;
    }

    public static void zoomIn(Vec3f aimingCorrection, int timer) {
        aiming = true;
        zoomCount = zoomCount == 0 ? 1 : zoomCount;
        zoomOutTimer = timer;
        AIMING_CORRECTION = aimingCorrection;
    }

    public static void zoomIn(Vec3f aimingCorrection) {
        aiming = true;
        zoomCount = zoomCount == 0 ? 1 : zoomCount;
        zoomOutTimer = 0;
        AIMING_CORRECTION = aimingCorrection;
    }

    public static void zoomOut(int timer) {
        aiming = false;
        zoomOutTimer = timer;
    }

    @SubscribeEvent
    public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
        if (zoomCount > 0) {
            CameraAnim.setRangedWeaponThirdPerson(event, Minecraft.m_91087_().f_91066_.m_92176_(), event.getPartialTick());
            zoomCount = aiming || zoomOutTimer-- > 0 ? zoomCount + 1 : zoomCount - 1;
            zoomCount = Math.min(20, zoomCount);
            if (zoomOutTimer < 0) {
                aiming = false;
            }
        }
    }

    private static void setRangedWeaponThirdPerson(ViewportEvent.ComputeCameraAngles event, CameraType pov, double partialTicks) {
        BlockPos cameraPos;
        if (ClientEngine.getInstance().getPlayerPatch() == null) {
            return;
        }
        Camera camera = event.getCamera();
        Entity entity = Minecraft.m_91087_().m_91288_();
        Vec3 vector = camera.m_90583_();
        double totalX = vector.m_7096_();
        double totalY = vector.m_7098_();
        double totalZ = vector.m_7094_();
        if (pov == CameraType.THIRD_PERSON_BACK) {
            double d3;
            double posX = vector.m_7096_();
            double posY = vector.m_7098_();
            double posZ = vector.m_7094_();
            double entityPosX = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * partialTicks;
            double entityPosY = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * partialTicks + (double)entity.m_20192_();
            double entityPosZ = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * partialTicks;
            float intpol = (float)zoomCount / 20.0f;
            Vec3f interpolatedCorrection = new Vec3f(CameraAnim.AIMING_CORRECTION.x * intpol, CameraAnim.AIMING_CORRECTION.y * intpol, CameraAnim.AIMING_CORRECTION.z * intpol);
            OpenMatrix4f rotationMatrix = ClientEngine.getInstance().getPlayerPatch().getMatrix((float)partialTicks);
            Vec3f rotateVec = OpenMatrix4f.transform3v((OpenMatrix4f)rotationMatrix, (Vec3f)interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockHitResult raytraceresult;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = Minecraft.m_91087_().f_91073_.m_45547_(new ClipContext(new Vec3(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))) == null || !((d7 = raytraceresult.m_82450_().m_82554_(new Vec3(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        if (Minecraft.m_91087_().f_91073_.m_8055_(cameraPos = new BlockPos((int)totalX, (int)totalY, (int)totalZ)).m_60713_(Blocks.f_50016_)) {
            camera.m_90584_(totalX, totalY, totalZ);
        }
    }

    static {
        AIMING_CORRECTION = DEFAULT_AIMING_CORRECTION = new Vec3f(1.5f, 0.0f, 1.25f);
        zoomOutTimer = 0;
    }
}

