/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.animation.custom;

import com.p1nero.wukong.client.event.CameraAnim;
import com.p1nero.wukong.epicfight.animation.custom.BasicMultipleAttackAnimation;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class StaffSpinAttackAnimation
extends BasicMultipleAttackAnimation {
    public StaffSpinAttackAnimation(float end, HumanoidArmature biped, String path, float damageMultiplier, boolean isTwoHand) {
        super(0.0f, path, (Armature)biped, new AttackAnimation.Phase(0.0f, 0.0f, 0.25f, end, 0.26f, biped.toolR, null).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)damageMultiplier)), new AttackAnimation.Phase(0.24f, 0.25f, 0.5f, end, 0.51f, biped.toolR, null).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)damageMultiplier)), new AttackAnimation.Phase(0.49f, 0.5f, 0.75f, end, 0.76f, biped.toolR, null).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)damageMultiplier)), new AttackAnimation.Phase(0.74f, 0.74f, 1.0f, end, end, biped.toolR, null).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)damageMultiplier)));
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
        this.addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 1.5f).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.TimeStampedEvent.create((livingEntityPatch, staticAnimation, objects) -> {
            if (isTwoHand && livingEntityPatch.getOriginal() instanceof LocalPlayer) {
                CameraAnim.zoomIn(new Vec3f(-1.0f, 0.0f, 1.25f), 20);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        ServerPlayerPatch serverPlayerPatch;
        super.begin(entityPatch);
        if (entityPatch instanceof ServerPlayerPatch && WukongWeaponCategories.isWeaponValid(serverPlayerPatch = (ServerPlayerPatch)entityPatch)) {
            SkillContainer passiveContainer = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE);
            passiveContainer.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.PLAYING_STAFF_SPIN.get(), (Object)true, (ServerPlayer)serverPlayerPatch.getOriginal());
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entityPatch, DynamicAnimation nextAnimation, boolean isEnd) {
        ServerPlayerPatch serverPlayerPatch;
        super.end(entityPatch, nextAnimation, isEnd);
        if (entityPatch instanceof ServerPlayerPatch && WukongWeaponCategories.isWeaponValid(serverPlayerPatch = (ServerPlayerPatch)entityPatch)) {
            SkillContainer passiveContainer = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE);
            passiveContainer.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.PLAYING_STAFF_SPIN.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
        }
        if (entityPatch.isLogicalClient() && CameraAnim.isAiming()) {
            CameraAnim.zoomOut(20);
        }
    }
}

