/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.animation.custom;

import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class WukongDodgeAnimation
extends DodgeAnimation {
    public WukongDodgeAnimation(float convertTime, float delayTime, String path, float width, float height, Armature armature, boolean isPerfect) {
        super(convertTime, delayTime, path, width, height, armature);
        this.addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)delayTime, (livingEntityPatch, staticAnimation, objects) -> {
            if (livingEntityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)livingEntityPatch;
                if (WukongWeaponCategories.isWeaponValid(livingEntityPatch)) {
                    ((ServerPlayer)serverPlayerPatch.getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
                        SkillContainer weaponInnate = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                        Boolean isCharging = (Boolean)weaponInnate.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get());
                        Boolean PILLAR_isCharging = (Boolean)weaponInnate.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get());
                        if (isCharging == null && PILLAR_isCharging == null) {
                            return;
                        }
                        if (isCharging != null) {
                            if (isCharging.booleanValue() && wkPlayer.isPerfectDodge() && !isPerfect) {
                                weaponInnate.getSkill().setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                                weaponInnate.getSkill().setStackSynchronize(serverPlayerPatch, 0);
                            }
                            weaponInnate.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                        } else if (PILLAR_isCharging != null) {
                            if (PILLAR_isCharging.booleanValue() && wkPlayer.isPerfectDodge() && !isPerfect) {
                                weaponInnate.getSkill().setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                                weaponInnate.getSkill().setStackSynchronize(serverPlayerPatch, 0);
                            }
                            weaponInnate.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                        }
                    });
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, delayTime).addState(EntityState.TURNING_LOCKED, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.INACTION, (Object)true).newTimePair(0.0f, delayTime).addState(EntityState.ATTACK_RESULT, (Object)DODGEABLE_SOURCE_VALIDATOR);
    }

    public WukongDodgeAnimation(float convertTime, float delayTime, String path, float width, float height, Armature armature) {
        this(convertTime, delayTime, path, width, height, armature, false);
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        super.begin(entityPatch);
        if (entityPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)entityPatch;
            ((ServerPlayer)playerPatch.getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> wkPlayer.setPerfectDodge(false));
        }
    }
}

