/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.fashu;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.p1nero.wukong.Config;
import com.p1nero.wukong.WukongMoveset;
import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.WukongSkillCategories;
import com.p1nero.wukong.epicfight.WukongSkillSlots;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class FashuAnshenfaSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0142ac114510");
    protected StaticAnimationProvider deriveAnimation1;
    protected StaticAnimationProvider deriveAnimation2;
    public int MAX_TICKS = 0;
    public int EFFECT_TIMER = 20;
    public int COOLING_TIMER = 50;
    public int Previously_recorded = 0;
    Vec3 playerPos;

    public static Builder create() {
        return new Builder().setCategory(WukongSkillCategories.FASHU_STYLE).setResource(Skill.Resource.NONE);
    }

    public FashuAnshenfaSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.deriveAnimation1 = builder.derive;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillContainer container = executer.getSkill((SkillSlot)WukongSkillSlots.FASHU_SKILL_SLOT);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get()) < 1) {
            executer.playSound((SoundEvent)WuKongSounds.FASHU_ASS.get(), 0.0f, 0.0f);
            executer.playAnimationSynchronized(this.deriveAnimation1.get(), 0.0f);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_ATTACK.get(), (Object)false, player);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_EFFECT_TIMER.get(), (Object)(this.EFFECT_TIMER * 20), player);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get(), (Object)(this.COOLING_TIMER * 20), player);
            this.playerPos = player.m_20182_();
            this.MAX_TICKS = 0;
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u5b89\u8eab\u672f\u51b7\u5374\u4e2d\u3002"));
        }
        super.executeOnServer(executer, args);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
            WukongMoveset.LOGGER.info("\u5b89\u8eab\u6cd5: {}", (Object)wkPlayer.getCoolingTimer());
            this.Previously_recorded = wkPlayer.getCoolingTimer();
        });
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        super.onRemoved(container);
        SkillDataManager dataManager = container.getDataManager();
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> wkPlayer.setCoolingTimer((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get())));
    }

    private void createFireCircles(ServerPlayer player, Vec3 position, SkillDataManager dataManager) {
        ServerLevel level = (ServerLevel)player.m_20193_();
        double radius = 4.7;
        int particleCount = 360;
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i * (Math.PI * 2 / (double)particleCount);
            double x = position.f_82479_ + radius * Math.cos(angle);
            double z = position.f_82481_ + radius * Math.sin(angle);
            double y = position.f_82480_ + 0.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 10, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void createRepelCircle(ServerPlayer player, Vec3 position, SkillDataManager dataManager) {
        double range = 4.7;
        double knockbackStrength = 0.24;
        List nearbyEntities = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(150.0), entity -> entity != player && entity.m_6084_());
        for (LivingEntity entity2 : nearbyEntities) {
            double distance;
            Vec3 monsterPos = entity2.m_20182_();
            double deltaX = monsterPos.f_82479_ - position.f_82479_;
            double deltaY = monsterPos.f_82480_ - position.f_82480_;
            double deltaZ = monsterPos.f_82481_ - position.f_82481_;
            if (!(entity2 instanceof Monster) || !((distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) <= range)) continue;
            entity2.m_20254_(1);
            if (Math.abs(deltaZ) > Math.abs(deltaX)) {
                if (deltaZ > 0.0) {
                    entity2.m_5997_(0.0, 0.0, knockbackStrength);
                    continue;
                }
                entity2.m_5997_(0.0, 0.0, -knockbackStrength);
                continue;
            }
            if (deltaX > 0.0) {
                entity2.m_5997_(knockbackStrength, 0.0, 0.0);
                continue;
            }
            entity2.m_5997_(-knockbackStrength, 0.0, 0.0);
        }
    }

    public void Replytohealthvolume(ServerPlayer player, Vec3 position, ServerPlayerPatch serverPlayerPatch) {
        double radius = 4.7;
        if (Math.pow(player.m_20185_() - position.f_82479_, 2.0) + Math.pow(player.m_20189_() - position.f_82481_, 2.0) <= Math.pow(radius, 2.0)) {
            Skill waponSkill = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
            waponSkill.setConsumptionSynchronize(serverPlayerPatch, serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
            player.m_5634_(0.2f);
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (!container.getExecuter().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (this.Previously_recorded != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get(), (Object)this.Previously_recorded, serverPlayer);
                this.Previously_recorded = 0;
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get()) > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get()) - 1), serverPlayer);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SPELL_EFFECT_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_EFFECT_TIMER.get()) - 1), serverPlayer);
                if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_EFFECT_TIMER.get()) > 1) {
                    this.createFireCircles(serverPlayer, this.playerPos, dataManager);
                    this.createRepelCircle(serverPlayer, this.playerPos, dataManager);
                    this.Replytohealthvolume(serverPlayer, this.playerPos, serverPlayerPatch);
                }
            }
        }
    }

    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int alpha = 128;
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/skills/spell_asf.png");
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get()) < 1) {
            alpha = 255;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        guiGraphics.m_280411_(styleTexture, pos.x - 32, pos.y - 20, 20, 20, 0.0f, 0.0f, 1, 1, 1, 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get()) > 0) {
            float second = (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SPELL_COOLING_TIMER.get())).intValue() / 20.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
            Font font = gui.font;
            String string = String.format("%.1f", Float.valueOf(second));
            int n = pos.x - 32 + (20 - gui.font.m_92895_(String.format("%.1f", Float.valueOf(second)))) / 2;
            int n2 = pos.y - 20;
            Objects.requireNonNull(gui.font);
            guiGraphics.m_280488_(font, string, n, n2 + (20 - 9) / 2, 0xFFFFFF);
        }
    }

    public static class Builder
    extends Skill.Builder<FashuAnshenfaSkill> {
        protected StaticAnimationProvider[] animationProviders;
        protected StaticAnimationProvider derive;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setAnimations(StaticAnimationProvider ... animationProviders) {
            this.animationProviders = animationProviders;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derive) {
            this.derive = derive;
            return this;
        }
    }
}

