/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.fashu;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.capability.entity.FakeWukongEntityPatch;
import com.p1nero.wukong.entity.FakeWukongEntity;
import com.p1nero.wukong.epicfight.WukongSkillCategories;
import com.p1nero.wukong.epicfight.WukongSkillSlots;
import com.p1nero.wukong.epicfight.animation.WukongAnimations;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.custom.avatar.HeavyAttack;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShenWaiShenFaSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0282ac114513");
    protected StaticAnimationProvider deriveAnimation1;

    public ShenWaiShenFaSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.deriveAnimation1 = builder.derive1;
    }

    public static Builder create() {
        return new Builder().setCategory(WukongSkillCategories.HAO_MAO).setResource(Skill.Resource.NONE);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, hurtEvent -> {
            FakeWukongEntity fakeWukongEntity;
            Entity patt3953$temp;
            if (((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal() == ((DamageSource)hurtEvent.getDamageSource()).m_7639_() || (patt3953$temp = ((DamageSource)hurtEvent.getDamageSource()).m_7639_()) instanceof FakeWukongEntity && (fakeWukongEntity = (FakeWukongEntity)patt3953$temp).m_269323_() != null && ((ServerPlayer)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal()).m_19879_() == fakeWukongEntity.m_269323_().m_19879_()) {
                hurtEvent.setAmount(0.0f);
                hurtEvent.setResult(AttackResult.ResultType.MISSED);
                hurtEvent.setCanceled(true);
            }
        }, 10);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, actionEvent -> {
            StaticAnimation animation = actionEvent.getAnimation();
            ServerPlayerPatch executor = (ServerPlayerPatch)actionEvent.getPlayerPatch();
            Skill weaponInnate = executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
            if (weaponInnate instanceof HeavyAttack) {
                HeavyAttack heavyAttacks = (HeavyAttack)weaponInnate;
                if (animation.equals((Object)WukongAnimations.STAFF_AUTO5) || this.isAnimationInList(heavyAttacks, animation)) {
                    ((ServerPlayer)executor.getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
                        for (int id : wkPlayer.getFakeWukongIds()) {
                            Entity patt5144$temp = ((ServerPlayer)executor.getOriginal()).m_9236_().m_6815_(id);
                            if (!(patt5144$temp instanceof FakeWukongEntity)) continue;
                            FakeWukongEntity fakeWukongEntity = (FakeWukongEntity)patt5144$temp;
                            if (executor.getTarget() == null || !(fakeWukongEntity.m_20270_((Entity)executor.getTarget()) < 4.0f)) continue;
                            fakeWukongEntity.m_21563_().m_148051_((Entity)executor.getTarget());
                            FakeWukongEntityPatch fakeWukongEntityPatch = (FakeWukongEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)fakeWukongEntity, FakeWukongEntityPatch.class);
                            fakeWukongEntityPatch.playAnimationSynchronized(animation, 0.15f);
                        }
                    });
                }
            }
        });
    }

    private boolean isAnimationInList(HeavyAttack animations, StaticAnimation animation) {
        for (StaticAnimationProvider animationz : animations.getHeavyAttacks()) {
            if (!animationz.get().equals((Object)animation)) continue;
            return true;
        }
        return false;
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        super.executeOnServer(executor, args);
        SkillContainer container = executor.getSkill((SkillSlot)WukongSkillSlots.HAO_MAO);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executor.getOriginal();
        if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get())).booleanValue()) {
            executor.playAnimationSynchronized(this.deriveAnimation1.get(), 0.0f);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get(), (Object)false, player);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_TIMER.get(), (Object)2400, player);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u8eab\u5916\u8eab\u6cd5\u51b7\u5374\u4e2d\u3002"));
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (!container.getExecuter().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get())).booleanValue()) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_TIMER.get()) - 1, 0), serverPlayer);
                if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_TIMER.get()) == 0) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get(), (Object)true, serverPlayer);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int alpha = 128;
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/skills/spell_swsf.png");
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get())).booleanValue()) {
            alpha = 255;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        guiGraphics.m_280411_(styleTexture, pos.x - 42, pos.y - 4, 20, 20, 0.0f, 0.0f, 1, 1, 1, 1);
        if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_ATTACK.get())).booleanValue()) {
            float second = (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.SWSF_COOLING_TIMER.get())).intValue() / 20.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
            Font font = gui.font;
            String string = String.format("%.1f", Float.valueOf(second));
            int n = pos.x - 42 + (20 - gui.font.m_92895_(String.format("%.1f", Float.valueOf(second)))) / 2 + 1;
            int n2 = pos.y - 4;
            Objects.requireNonNull(gui.font);
            guiGraphics.m_280488_(font, string, n, n2 + (20 - 9) / 2 + 1, 0xFFFFFF);
        }
    }

    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return super.canExecute(executer);
    }

    public static class Builder
    extends Skill.Builder<ShenWaiShenFaSkill> {
        protected StaticAnimationProvider derive1;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derive1) {
            this.derive1 = derive1;
            return this;
        }
    }
}

