/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.fashu;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.p1nero.wukong.WukongMoveset;
import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.entity.CloudStepLeftEntity;
import com.p1nero.wukong.epicfight.WukongSkillCategories;
import com.p1nero.wukong.epicfight.WukongSkillSlots;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import com.p1nero.wukong.network.PacketHandler;
import com.p1nero.wukong.network.PacketRelay;
import com.p1nero.wukong.network.packet.client.AddEntityAfterImageWithTextureParticle;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShenfaJuxingsanqiSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0252ac114513");
    public static final int MAX_TIME = 200;
    protected StaticAnimationProvider deriveAnimation1;
    protected StaticAnimationProvider deriveAnimation2;
    protected StaticAnimationProvider deriveAnimation3;
    ItemStack currentWeapon;
    public int EFFECT_TIMER = 10;
    public int COOLING_TIMER = 35;
    public static final int MAX_TRANSPARENT_TIMER = 200;
    public int Previously_recorded = 0;

    public static Builder create() {
        return new Builder().setCategory(WukongSkillCategories.SHENFA_STYLE).setResource(Skill.Resource.NONE);
    }

    public ShenfaJuxingsanqiSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.deriveAnimation1 = builder.derive1;
        this.deriveAnimation2 = builder.derive2;
        this.deriveAnimation3 = builder.derive3;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillContainer container = executer.getSkill((SkillSlot)WukongSkillSlots.SHENFA_SKILL_SLOT);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) < 1) {
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)(this.EFFECT_TIMER * 20), player);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)(this.COOLING_TIMER * 20), player);
            executer.playSound((SoundEvent)WuKongSounds.SHENFA_JXSQ_CAST.get(), 0.0f, 0.0f);
            executer.playAnimationSynchronized(this.deriveAnimation1.get(), 0.0f);
            PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddEntityAfterImageWithTextureParticle(((ServerPlayer)executer.getOriginal()).m_19879_()));
            ((ServerPlayer)executer.getOriginal()).m_9236_().m_7967_((Entity)new CloudStepLeftEntity((LivingEntityPatch<?>)executer));
        }
        super.executeOnServer(executer, args);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 1 && !event.getPlayerPatch().isLogicalClient()) {
                PlayerPatch executer = event.getPlayerPatch();
                ServerPlayer player = (ServerPlayer)executer.getOriginal();
                Vec3 playerPos = player.m_20182_();
                double radius = 10.0;
                AABB range = new AABB(playerPos.m_82492_(radius, radius, radius), playerPos.m_82520_(radius, radius, radius));
                List nearbyEntities = player.m_9236_().m_6443_(Entity.class, range, entity -> entity instanceof Monster);
                if (event.getSkillContainer().getSkill().getCategory().equals(SkillCategories.BASIC_ATTACK) && (Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 10) {
                    event.setCanceled(true);
                    if (nearbyEntities.size() > 0) {
                        event.getPlayerPatch().playAnimationSynchronized(this.deriveAnimation2.get(), 0.0f);
                    } else {
                        event.getPlayerPatch().playAnimationSynchronized(this.deriveAnimation3.get(), 0.0f);
                    }
                    container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)0, (ServerPlayer)event.getPlayerPatch().getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 10) {
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            PlayerPatch executer = event.getPlayerPatch();
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 10) {
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        super.onInitiate(container);
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
            WukongMoveset.LOGGER.info("\u8eab\u6cd5: {}", (Object)wkPlayer.getCoolingTimer());
            this.Previously_recorded = wkPlayer.getbodyCoolingTimer();
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        SkillDataManager dataManager = container.getDataManager();
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> wkPlayer.setbodyCoolingTimer((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get())));
    }

    public void restoreArmor(ServerPlayer player, ItemStack[] savedArmor) {
        int i;
        player.m_21008_(InteractionHand.MAIN_HAND, this.currentWeapon);
        for (i = 0; i < 4; ++i) {
            player.m_8061_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i), savedArmor[i]);
        }
        for (i = 0; i < 4; ++i) {
            player.m_8061_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i), savedArmor[i]);
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (!container.getExecuter().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (this.Previously_recorded != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)this.Previously_recorded, serverPlayer);
                this.Previously_recorded = 0;
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) - 1), serverPlayer);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) - 1), serverPlayer);
                if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 1) {
                    // empty if block
                }
            }
        }
    }

    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int alpha = 128;
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/skills/spell_jxsq.png");
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) < 1) {
            alpha = 255;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        guiGraphics.m_280411_(styleTexture, pos.x - 52, pos.y - 20, 20, 20, 0.0f, 0.0f, 1, 1, 1, 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) > 0) {
            float second = (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get())).intValue() / 20.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
            Font font = gui.font;
            String string = String.format("%.1f", Float.valueOf(second));
            int n = pos.x - 52 + (20 - gui.font.m_92895_(String.format("%.1f", Float.valueOf(second)))) / 2;
            int n2 = pos.y - 20;
            Objects.requireNonNull(gui.font);
            guiGraphics.m_280488_(font, string, n, n2 + (20 - 9) / 2, 0xFFFFFF);
        }
    }

    public static class Builder
    extends Skill.Builder<ShenfaJuxingsanqiSkill> {
        protected StaticAnimationProvider[] animationProviders;
        protected StaticAnimationProvider derive1;
        protected StaticAnimationProvider derive2;
        protected StaticAnimationProvider derive3;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setAnimations(StaticAnimationProvider ... animationProviders) {
            this.animationProviders = animationProviders;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derive1, StaticAnimationProvider derive2, StaticAnimationProvider derive3) {
            this.derive1 = derive1;
            this.derive2 = derive2;
            this.derive3 = derive3;
            return this;
        }
    }
}

