/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.fashu;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.WukongSkillCategories;
import com.p1nero.wukong.epicfight.WukongSkillSlots;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.custom.wukong.StaffStance;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShenfaTongtoutiebiSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0272ac114513");
    protected StaticAnimationProvider deriveAnimation1;
    protected StaticAnimationProvider deriveAnimation2;
    public int EFFECT_TIMER = 2;
    public int COOLING_TIMER = 15;
    public int Previously_recorded = 0;

    public static Builder create() {
        return new Builder().setCategory(WukongSkillCategories.SHENFA_STYLE).setResource(Skill.Resource.NONE);
    }

    public ShenfaTongtoutiebiSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.deriveAnimation1 = builder.derive1;
        this.deriveAnimation2 = builder.derive2;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillContainer container = executer.getSkill((SkillSlot)WukongSkillSlots.SHENFA_SKILL_SLOT);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) < 1) {
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)(this.EFFECT_TIMER * 20), player);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)(this.COOLING_TIMER * 20), player);
            executer.playAnimationSynchronized(this.deriveAnimation1.get(), 0.0f);
        }
        super.executeOnServer(executer, args);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 0) {
                Skill patt4794$temp;
                serverPlayerPatch.playSound((SoundEvent)WuKongSounds.SHENFA_TTTB.get(), 1.0f, 1.0f);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                SkillContainer containe = serverPlayerPatch.getSkill((SkillSlot)WukongSkillSlots.STAFF_STYLE);
                if (containe != null && (patt4794$temp = containe.getSkill()) instanceof StaffStance) {
                    StaffStance style = (StaffStance)patt4794$temp;
                    this.modifyStamina((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), 5.0f);
                    serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get(), (Object)true, (ServerPlayer)serverPlayerPatch.getOriginal());
                }
                event.setResult(AttackResult.ResultType.MISSED);
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
        });
        super.onInitiate(container);
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        SkillDataManager dataManager = container.getDataManager();
        super.onRemoved(container);
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> wkPlayer.setbodyCoolingTimer((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get())));
    }

    public void modifyStamina(LivingEntity livingentity, float staminaChange) {
        float currentStamina = ((Float)livingentity.m_20088_().m_135370_(PlayerPatch.STAMINA)).floatValue();
        float newStamina = Math.max(0.0f, currentStamina + staminaChange);
        livingentity.m_20088_().m_135381_(PlayerPatch.STAMINA, (Object)Float.valueOf(newStamina));
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (!container.getExecuter().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (this.Previously_recorded != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)this.Previously_recorded, serverPlayer);
                this.Previously_recorded = 0;
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) - 1), serverPlayer);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) - 1), serverPlayer);
                if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_EFFECT_TIMER.get()) > 1) {
                    // empty if block
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int alpha = 128;
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/skills/spell_tttb.png");
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) < 1) {
            alpha = 255;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        guiGraphics.m_280411_(styleTexture, pos.x - 52, pos.y - 20, 20, 20, 0.0f, 0.0f, 1, 1, 1, 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get()) > 0) {
            float second = (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.BODY_COOLING_TIMER.get())).intValue() / 20.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
            Font font = gui.font;
            String string = String.format("%.1f", Float.valueOf(second));
            int n = pos.x - 52 + (20 - gui.font.m_92895_(String.format("%.1f", Float.valueOf(second)))) / 2;
            int n2 = pos.y - 20;
            Objects.requireNonNull(gui.font);
            guiGraphics.m_280488_(font, string, n, n2 + (20 - 9) / 2, 0xFFFFFF);
        }
    }

    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return super.canExecute(executer);
    }

    public static class Builder
    extends Skill.Builder<ShenfaTongtoutiebiSkill> {
        protected StaticAnimationProvider[] animationProviders;
        protected StaticAnimationProvider derive1;
        protected StaticAnimationProvider derive2;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setAnimations(StaticAnimationProvider ... animationProviders) {
            this.animationProviders = animationProviders;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derive1, StaticAnimationProvider derive2) {
            this.derive1 = derive1;
            this.derive2 = derive2;
            return this;
        }
    }
}

