/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.mojang.blaze3d.platform.Window;
import com.p1nero.wukong.Config;
import com.p1nero.wukong.WukongMoveset;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.WukongStyles;
import com.p1nero.wukong.epicfight.animation.WukongAnimations;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.custom.avatar.HeavyAttack;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PillarHeavyAttack
extends WeaponInnateSkill
implements HeavyAttack {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0242ac114513");
    public static final int MAX_ANGLE_FOV = 74;
    public static final int MAX_FOVLJ = 0;
    protected final StaticAnimationProvider[] start;
    protected final StaticAnimationProvider[] up;
    protected final StaticAnimationProvider[] heavy;
    protected StaticAnimationProvider deriveAnimation1;
    protected StaticAnimationProvider deriveAnimation2;
    protected StaticAnimationProvider hotwheel;
    protected StaticAnimationProvider deriveEnd;

    @Override
    public List<StaticAnimationProvider> getHeavyAttacks() {
        ArrayList<StaticAnimationProvider> staticAnimations = new ArrayList<StaticAnimationProvider>(List.of(this.heavy));
        staticAnimations.add(this.deriveAnimation2);
        return staticAnimations;
    }

    public static Builder createChargedAttack() {
        return new Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.NONE);
    }

    public PillarHeavyAttack(Builder builder) {
        super((Skill.Builder)builder);
        this.start = builder.start;
        this.up = builder.up;
        this.heavy = builder.heavy;
        this.deriveAnimation1 = builder.derive1;
        this.deriveAnimation2 = builder.derive2;
        this.hotwheel = builder.hotwheel;
        this.deriveEnd = builder.deriveEnd;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        boolean stackConsumed;
        SkillContainer container = executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get(), (Object)container.getStack(), player);
        boolean bl = stackConsumed = container.getStack() > 0;
        if (container.getStack() == 4) {
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
            if (container.getStack() > 0) {
                this.CameraOperationFov(7.0f, 31, container.getStack());
            }
            executer.playAnimationSynchronized(this.start[container.getStack()].get(), 0.0f);
        } else if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_FASHU_TIMER.get()) > 0) {
            executer.playAnimationSynchronized(this.start[container.getStack()].get(), 0.0f);
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PILLAR_FASHU_TIMER.get(), (Object)0);
            this.setStackSynchronize(executer, container.getStack() - 1);
        } else if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) > 0 && stackConsumed) {
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PILLAR_FENG_YU_ZHUAN.get(), (Object)true);
            executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(container.getStack() - 1).get(), 1.0f, 1.0f);
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
            executer.playAnimationSynchronized(this.deriveAnimation1.get(), 0.0f);
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)0);
            this.setStackSynchronize(executer, container.getStack() - 1);
        } else if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_JIANGHAIFAN_TIMER.get()) > 0 && stackConsumed) {
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PILLAR_JIANGHAIFAN_TIMER.get(), (Object)0, player);
            executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(container.getStack() - 1).get(), 1.0f, 1.0f);
            this.setStackSynchronize(executer, container.getStack() - 1);
            executer.playAnimationSynchronized(this.deriveAnimation2.get(), 0.0f);
        } else if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue() && PillarHeavyAttack.checkSpace(player, container.getStack() * 2)) {
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
            if (container.getStack() > 0) {
                this.CameraOperationFov(7.0f, 31, container.getStack());
            }
            executer.playAnimationSynchronized(this.start[container.getStack()].get(), 0.0f);
        }
        super.executeOnServer(executer, args);
    }

    public void CameraOperationFov(float increaseAmount, final int durationTicks, final int repeatTimes) {
        final Minecraft MC = Minecraft.m_91087_();
        final float startFov = ((Integer)MC.f_91066_.m_231837_().m_231551_()).intValue();
        final float targetFov = Math.min(startFov + increaseAmount, 97.0f);
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        final AtomicInteger tickCount = new AtomicInteger(0);
        final AtomicInteger repeatCount = new AtomicInteger(0);
        Runnable task = new Runnable(){
            private float currentStartFov;
            {
                this.currentStartFov = startFov;
            }

            @Override
            public void run() {
                int currentTick = tickCount.incrementAndGet();
                if (currentTick > durationTicks) {
                    tickCount.set(0);
                    repeatCount.incrementAndGet();
                    if (repeatCount.get() >= repeatTimes) {
                        scheduler.shutdown();
                        return;
                    }
                    this.currentStartFov = ((Integer)MC.f_91066_.m_231837_().m_231551_()).intValue();
                }
                float progress = (float)currentTick / (float)durationTicks;
                float newFov = this.currentStartFov + (targetFov - this.currentStartFov) * progress;
                MC.f_91066_.m_231837_().m_231514_((Object)((int)newFov));
            }
        };
        scheduler.scheduleAtFixedRate(task, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void CameraResetFov(int durationTicks) {
        Minecraft MC = Minecraft.m_91087_();
        float currentFov = ((Integer)MC.f_91066_.m_231837_().m_231551_()).intValue();
        float targetFov = 70.0f;
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        AtomicInteger tickCount = new AtomicInteger(0);
        Runnable task = () -> {
            int currentTick = tickCount.incrementAndGet();
            if (currentTick > durationTicks) {
                scheduler.shutdown();
                MC.f_91066_.m_231837_().m_231514_((Object)((int)targetFov));
                return;
            }
            float progress = (float)currentTick / (float)durationTicks;
            float newFov = currentFov + (targetFov - currentFov) * progress;
            MC.f_91066_.m_231837_().m_231514_((Object)((int)newFov));
        };
        scheduler.scheduleAtFixedRate(task, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void resetConsumption(SkillContainer container, ServerPlayerPatch executer) {
        if (container.getStack() > 0) {
            int n = container.getStack();
        }
        this.setStackSynchronize(executer, 0);
        this.setConsumptionSynchronize(executer, 1.0f);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.PILLAR_HEAVY_FENGYUNZHUAN.get()) && container.getStack() < 4) {
                container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            Input input;
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_()) {
                input = event.getMovementInput();
                input.f_108572_ = false;
            }
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_()) {
                input = event.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108572_ = false;
                input.f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)event.getPlayerPatch();
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)player.m_21205_());
            if (!WukongWeaponCategories.isWeaponValid(event.getPlayerPatch())) {
                return;
            }
            List autoAnimations = capabilityItem.getAutoAttckMotion(event.getPlayerPatch());
            for (int i = 0; i < autoAnimations.size(); ++i) {
                if (!((AnimationProvider)autoAnimations.get(i)).get().equals((Object)event.getAnimation()) || i >= 4) continue;
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)((Double)Config.DERIVE_CHECK_TIME.get()).intValue(), player);
                return;
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            EpicFightDamageSource epicFightDamageSource;
            Object patt13521$temp = event.getDamageSource();
            if (patt13521$temp instanceof EpicFightDamageSource && (epicFightDamageSource = (EpicFightDamageSource)patt13521$temp).m_269533_(EpicFightDamageType.PARTIAL_DAMAGE)) {
                return;
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                Object patt13811$temp = event.getDamageSource();
                if (patt13811$temp instanceof EpicFightDamageSource) {
                    epicFightDamageSource = (EpicFightDamageSource)patt13811$temp;
                    epicFightDamageSource.setStunType(StunType.NONE);
                }
                event.setAmount(event.getAmount());
                LivingEntityPatch attackerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
                this.processDamage(event.getPlayerPatch(), (DamageSource)event.getDamageSource(), AttackResult.ResultType.SUCCESS, event.getAmount(), attackerPatch);
                event.setResult(AttackResult.ResultType.MISSED);
                event.setCanceled(true);
            }
        });
        super.onInitiate(container);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID);
    }

    public static boolean checkSpace(ServerPlayer serverPlayer, int height) {
        ServerLevel serverLevel = serverPlayer.m_284548_();
        for (int i = 1; i <= height; ++i) {
            if (serverLevel.m_8055_(serverPlayer.m_20097_().m_6630_(i)).m_60713_(Blocks.f_50016_)) continue;
            return false;
        }
        return true;
    }

    public void processDamage(PlayerPatch<?> playerPatch, DamageSource damageSource, AttackResult.ResultType attackResult, float amount, @Nullable LivingEntityPatch<?> attackerPatch) {
        EpicFightDamageSource epicFightDamageSource;
        AttackResult result;
        AttackResult attackResult2 = result = playerPatch != null ? AttackResult.of((AttackResult.ResultType)attackResult, (float)amount) : AttackResult.success((float)amount);
        if (attackerPatch != null) {
            attackerPatch.setLastAttackResult(result);
        }
        EpicFightDamageSource deflictedDamage = damageSource instanceof EpicFightDamageSource ? (epicFightDamageSource = (EpicFightDamageSource)damageSource) : EpicFightDamageSources.copy((DamageSource)damageSource);
        deflictedDamage.addRuntimeTag(EpicFightDamageType.PARTIAL_DAMAGE);
        if (playerPatch != null) {
            ((Player)playerPatch.getOriginal()).m_6469_((DamageSource)deflictedDamage, result.damage);
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (container.getExecuter().isLogicalClient()) {
            boolean isKeyDown = EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_();
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get(), (Object)isKeyDown, (LocalPlayer)container.getExecuter().getOriginal());
        } else {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (container.getStack() > (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get())) {
                serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PLAY_SOUND.get(), (Object)false, serverPlayer);
                if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue() && !((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_FENG_YU_ZHUAN.get())).booleanValue() && (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get()) < 3) {
                    serverPlayerPatch.playAnimationSynchronized(this.up[(Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get())].get(), 0.1f);
                }
            }
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get(), (Object)container.getStack());
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PILLAR_FASHU_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_FASHU_TIMER.get()) - 1, 0), serverPlayer);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) - 1, 0), serverPlayer);
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get())).booleanValue()) {
                if (container.getStack() < 3) {
                    this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get(), (Object)container.getStack());
                }
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get(), (Object)false, serverPlayer);
            }
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) - 1, 0), serverPlayer);
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) - 1), serverPlayer);
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_JIANGHAIFAN_TIMER.get()) > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PILLAR_JIANGHAIFAN_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_JIANGHAIFAN_TIMER.get()) - 1), serverPlayer);
            }
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                if (!WukongWeaponCategories.isWeaponValid(serverPlayerPatch)) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    this.setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                    this.setStackSynchronize(serverPlayerPatch, 0);
                    return;
                }
                if (container.getStack() < 3 && ((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                    this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
                }
                WukongMoveset.LOGGER.info("PILLAR_KEY_PRESSING: {}", dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get()));
                if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get())).booleanValue()) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_ATTACK_4.get(), 2.0f, 2.0f);
                    serverPlayerPatch.playAnimationSynchronized(this.heavy[container.getStack()].get(), 0.0f);
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get(), (Object)container.getStack(), serverPlayer);
                    this.resetConsumption(container, serverPlayerPatch);
                }
            }
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.PILLAR_FENG_YU_ZHUAN.get())).booleanValue() && !((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get())).booleanValue()) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PILLAR_FENG_YU_ZHUAN.get(), (Object)false, serverPlayer);
                serverPlayerPatch.playAnimationSynchronized(this.deriveEnd.get(), 0.0f);
            }
            if (container.getStack() < 1 && (double)container.getResource() > (double)container.getMaxResource() * 0.3) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 2 && (double)container.getResource() > (double)container.getMaxResource() * 0.5) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 3 && (double)container.getResource() > (double)container.getMaxResource() * 0.7) {
                this.breakProgress(serverPlayerPatch, container);
            }
            int current = (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CHARGED4_TIMER.get());
            if (current > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CHARGED4_TIMER.get(), (Object)(current - 1), serverPlayer);
            }
            float consumption = ((Double)Config.CHARGING_SPEED.get()).floatValue() / 5.0f;
            if (current == 1 && container.isFull()) {
                this.setStackSynchronize(serverPlayerPatch, 3);
                this.setConsumptionSynchronize(serverPlayerPatch, container.getMaxResource() - consumption);
            }
            if (current == 0 && container.getStack() >= 3 && (double)container.getResource() > (double)consumption + 0.1) {
                this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() - consumption);
            }
        }
    }

    public void breakProgress(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        this.setConsumptionSynchronize(serverPlayerPatch, 0.1f);
        this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        int star;
        int stack = container.getStack();
        int style = container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()).universalOrdinal() - WukongStyles.SMASH.universalOrdinal();
        float cooldownRatio = !container.isFull() && !container.isActivated() ? container.getResource(1.0f) : 1.0f;
        int progress = (int)Math.ceil(cooldownRatio * 40.0f);
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation progressTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/progress/" + progress + ".png");
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stance/" + style + (stack == 4 ? "_1" : "_0") + ".png");
        ResourceLocation stackBgTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/ui" + stack + ".png");
        ResourceLocation stackTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/stack" + stack + ".png");
        ResourceLocation goldenLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/gold.png");
        ResourceLocation whiteLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/white.png");
        ResourceLocation redLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/red.png");
        guiGraphics.m_280411_(progressTexture, pos.x - 12, pos.y - 12, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
        this.drawTexture(guiGraphics, styleTexture, pos.x - 12, pos.y - 12);
        this.drawTexture(guiGraphics, stackBgTexture, pos.x - 12, pos.y - 12);
        Vec2i light1 = new Vec2i(pos.x - 14, pos.y + 3);
        Vec2i light2 = new Vec2i(pos.x - 5, pos.y + 1);
        Vec2i light3 = new Vec2i(pos.x + 4, pos.y - 5);
        List<Vec2i> lightList = List.of(light1, light2, light3);
        if (container.isFull()) {
            for (Vec2i lightPos : lightList) {
                this.drawTexture(guiGraphics, goldenLightTexture, lightPos.x, lightPos.y);
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) > 0 && (star = Math.min((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get()), 3)) > 0) {
            for (int i = 0; i < star; ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, redLightTexture, lightPos.x, lightPos.y);
            }
        }
        if (stack > 0) {
            for (int i = 0; i < Math.min(stack, 3); ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, whiteLightTexture, lightPos.x, lightPos.y);
            }
            this.drawTexture(guiGraphics, stackTexture, pos.x - 12, pos.y - 12);
        }
    }

    public void drawTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        guiGraphics.m_280411_(texture, x, y, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    public static class Builder
    extends Skill.Builder<PillarHeavyAttack> {
        protected StaticAnimationProvider[] start;
        protected StaticAnimationProvider[] up;
        protected StaticAnimationProvider[] heavy;
        protected StaticAnimationProvider derive1;
        protected StaticAnimationProvider derive2;
        protected StaticAnimationProvider deriveLoop;
        protected StaticAnimationProvider deriveEnd;
        protected StaticAnimationProvider hotwheel;
        StaticAnimationProvider pre;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setChargePreAnimation(StaticAnimationProvider pre) {
            this.pre = pre;
            return this;
        }

        public Builder setStartAnimations(StaticAnimationProvider ... animationProviders) {
            this.start = animationProviders;
            return this;
        }

        public Builder setUpAnimations(StaticAnimationProvider ... animationProviders) {
            this.up = animationProviders;
            return this;
        }

        public Builder setHeavyAttacks(StaticAnimationProvider ... animationProviders) {
            this.heavy = animationProviders;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derivePre, StaticAnimationProvider deriveLoop, StaticAnimationProvider deriveEnd, StaticAnimationProvider derive2) {
            this.derive1 = derivePre;
            this.deriveLoop = deriveLoop;
            this.deriveEnd = deriveEnd;
            this.derive2 = derive2;
            return this;
        }
    }
}

