/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.mojang.blaze3d.platform.Window;
import com.p1nero.wukong.Config;
import com.p1nero.wukong.WukongMoveset;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.WukongStyles;
import com.p1nero.wukong.epicfight.animation.custom.WukongDodgeAnimation;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.custom.avatar.HeavyAttack;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import com.p1nero.wukong.item.WukongItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SmashHeavyAttack
extends WeaponInnateSkill
implements HeavyAttack {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0242ac114512");
    @NotNull
    protected final StaticAnimationProvider[] animations;
    public static final int MAX_CHARGED4_TICKS = 300;
    protected StaticAnimationProvider deriveAnimation1;
    protected StaticAnimationProvider deriveAnimation2;
    protected StaticAnimationProvider deriveAnimation3;
    @NotNull
    protected StaticAnimationProvider jumpAttackHeavy;
    @NotNull
    protected StaticAnimationProvider chargePre;

    @Override
    public List<StaticAnimationProvider> getHeavyAttacks() {
        ArrayList<StaticAnimationProvider> staticAnimations = new ArrayList<StaticAnimationProvider>(List.of(this.animations));
        staticAnimations.add(this.deriveAnimation2);
        return staticAnimations;
    }

    public static Builder createChargedAttack() {
        return new Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.NONE);
    }

    public SmashHeavyAttack(Builder builder) {
        super((Skill.Builder)builder);
        this.chargePre = builder.pre;
        this.animations = builder.animationProviders;
        this.deriveAnimation1 = builder.derive1;
        this.deriveAnimation2 = builder.derive2;
        this.deriveAnimation3 = builder.derive3;
        this.jumpAttackHeavy = builder.jumpAttackHeavy;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillContainer container = executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get(), (Object)container.getStack(), player);
        if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_JUMP_HEAVY.get())).booleanValue() && !player.m_20096_()) {
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_JUMP_HEAVY.get(), (Object)false, player);
            if (container.getStack() > 0) {
                executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(container.getStack() - 1).get(), 1.0f, 1.0f);
            }
            executer.playAnimationSynchronized(this.jumpAttackHeavy.get(), 0.15f);
            this.resetConsumption(container, executer, false);
        } else if (player.m_20096_()) {
            boolean stackConsumed;
            boolean bl = stackConsumed = container.getStack() > 0;
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) > 0 && !container.isFull()) {
                if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_FIRST_DERIVE.get())).booleanValue()) {
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
                    executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                    this.setStackSynchronize(executer, container.getStack() - 1);
                    executer.playAnimationSynchronized(this.deriveAnimation1.get(), 0.2f);
                } else if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_DERIVE.get())).booleanValue()) {
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
                    executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                    this.setStackSynchronize(executer, container.getStack() - 1);
                    executer.playAnimationSynchronized(this.deriveAnimation2.get(), 0.2f);
                }
            } else {
                WukongMoveset.LOGGER.info("\u91cd\u51fb");
                if (container.getStack() == 4) {
                    ItemStack mainHandItem = player.m_21205_();
                    ItemStack offHandItem = player.m_21206_();
                    ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
                    ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
                    ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
                    ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
                    if (helmet.m_150930_((Item)WukongItems.DASHENG_H.get()) && chestplate.m_150930_((Item)WukongItems.DASHENG_C.get()) && leggings.m_150930_((Item)WukongItems.DASHENG_L.get()) && boots.m_150930_((Item)WukongItems.DASHENG_F.get())) {
                        executer.playAnimationSynchronized(this.deriveAnimation3.get(), 0.2f);
                    } else if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                        executer.playAnimationSynchronized(this.chargePre.get(), 0.2f);
                    }
                } else if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                    executer.playAnimationSynchronized(this.chargePre.get(), 0.2f);
                }
            }
        }
        super.executeOnServer(executer, args);
    }

    private void resetConsumption(SkillContainer container, ServerPlayerPatch executer, boolean playSound) {
        if (playSound && container.getStack() > 0) {
            int cnt = container.getStack();
            new Thread(() -> {
                for (int i = 0; i < cnt; ++i) {
                    executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(i).get(), 1.0f, 1.0f);
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        WukongMoveset.LOGGER.error("interrupted when play stack sounds!", (Throwable)e);
                    }
                }
            }).start();
        } else {
            container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.PLAY_SOUND.get(), (Object)true, (ServerPlayer)executer.getOriginal());
        }
        container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)((Double)Config.DERIVE_CHECK_TIME.get()).intValue(), (ServerPlayer)executer.getOriginal());
        this.setStackSynchronize(executer, 0);
        this.setConsumptionSynchronize(executer, 1.0f);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_()) {
                Input input = event.getMovementInput();
                input.f_108572_ = false;
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            float damageReduce;
            EpicFightDamageSource epicFightDamageSource;
            Object patt12205$temp = event.getDamageSource();
            if (patt12205$temp instanceof EpicFightDamageSource && (epicFightDamageSource = (EpicFightDamageSource)patt12205$temp).m_269533_(EpicFightDamageType.PARTIAL_DAMAGE)) {
                return;
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_IN_SPECIAL_ATTACK.get())).booleanValue()) {
                if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_SPECIAL_SUCCESS.get())).booleanValue()) {
                    container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue() * 30.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.IS_SPECIAL_SUCCESS.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
                BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)((ServerPlayerPatch)event.getPlayerPatch()), (SkillContainer)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.BASIC_ATTACK), (StaticAnimation)this.deriveAnimation1.get(), (int)2);
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
            if ((damageReduce = ((Float)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.DAMAGE_REDUCE.get())).floatValue()) > 0.0f) {
                Object patt13439$temp = event.getDamageSource();
                if (patt13439$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicFightDamageSource2 = (EpicFightDamageSource)patt13439$temp;
                    epicFightDamageSource2.setStunType(StunType.NONE);
                }
                event.setAmount(event.getAmount() * (1.0f - damageReduce));
                LivingEntityPatch attackerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
                this.processDamage(event.getPlayerPatch(), (DamageSource)event.getDamageSource(), AttackResult.ResultType.SUCCESS, (1.0f - damageReduce) * event.getAmount(), attackerPatch);
                event.setResult(AttackResult.ResultType.MISSED);
                event.setCanceled(true);
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.DAMAGE_REDUCE.get(), (Object)Float.valueOf(-1.0f));
            }
            if (((DamageSource)event.getDamageSource()).m_276093_(DamageTypes.f_268671_) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get())).booleanValue()) {
                System.out.println("man!");
                event.setAmount(0.0f);
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_183634_();
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)event.getPlayerPatch();
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)player.m_21205_());
            if (!WukongWeaponCategories.isWeaponValid(event.getPlayerPatch())) {
                return;
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue() && !event.getAnimation().equals((Object)this.chargePre.get()) && !(event.getAnimation() instanceof WukongDodgeAnimation)) {
                this.setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                this.setStackSynchronize(serverPlayerPatch, 0);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, player);
            }
            List autoAnimations = capabilityItem.getAutoAttckMotion(event.getPlayerPatch());
            for (int i = 0; i < autoAnimations.size(); ++i) {
                if (!((AnimationProvider)autoAnimations.get(i)).get().equals((Object)event.getAnimation()) || i >= 4) continue;
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_FIRST_DERIVE.get(), (Object)true, player);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)((Double)Config.DERIVE_CHECK_TIME.get()).intValue(), player);
                return;
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (container.isFull()) {
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.CHARGED4_TIMER.get(), (Object)300, player);
            }
            if (event.getDamageSource().getAnimation().equals((Object)this.deriveAnimation1.get())) {
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_DERIVE.get(), (Object)true, player);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)((Double)Config.DERIVE_CHECK_TIME.get()).intValue(), player);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            int starCnt = (Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get());
            if (event.getDamageSource().getAnimation().equals((Object)this.jumpAttackHeavy.get())) {
                float mul = switch (starCnt) {
                    case 1 -> 3.0f;
                    case 2 -> 4.5f;
                    case 3 -> 6.2f;
                    case 4 -> 8.75f;
                    default -> 1.45f;
                };
                event.getDamageSource().setDamageModifier(ValueModifier.multiplier((float)mul));
            } else if (event.getDamageSource().getAnimation().equals((Object)this.deriveAnimation1.get())) {
                float mul = starCnt == 0 ? 1.0f : 1.96f;
                event.getDamageSource().setDamageModifier(ValueModifier.multiplier((float)mul));
            } else if (event.getDamageSource().getAnimation().equals((Object)this.deriveAnimation2.get())) {
                float mul = switch (starCnt) {
                    case 1 -> 4.7f;
                    case 2 -> 4.9f;
                    case 3, 4 -> 5.1f;
                    default -> 4.48f;
                };
                event.getDamageSource().setDamageModifier(ValueModifier.multiplier((float)mul));
            }
            event.getTarget().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                LivingEntityPatch livingEntityPatch;
                if (entityPatch instanceof LivingEntityPatch && (livingEntityPatch = (LivingEntityPatch)entityPatch).getEntityState().knockDown()) {
                    event.getDamageSource().setStunType(StunType.NONE);
                }
            });
        });
        super.onInitiate(container);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    public void processDamage(PlayerPatch<?> playerPatch, DamageSource damageSource, AttackResult.ResultType attackResult, float amount, @Nullable LivingEntityPatch<?> attackerPatch) {
        EpicFightDamageSource epicFightDamageSource;
        AttackResult result;
        AttackResult attackResult2 = result = playerPatch != null ? AttackResult.of((AttackResult.ResultType)attackResult, (float)amount) : AttackResult.success((float)amount);
        if (attackerPatch != null) {
            attackerPatch.setLastAttackResult(result);
        }
        EpicFightDamageSource deflictedDamage = damageSource instanceof EpicFightDamageSource ? (epicFightDamageSource = (EpicFightDamageSource)damageSource) : EpicFightDamageSources.copy((DamageSource)damageSource);
        deflictedDamage.addRuntimeTag(EpicFightDamageType.PARTIAL_DAMAGE);
        if (playerPatch != null) {
            ((Player)playerPatch.getOriginal()).m_6469_((DamageSource)deflictedDamage, result.damage);
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (container.getExecuter().isLogicalClient()) {
            boolean isKeyDown = EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_();
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get(), (Object)isKeyDown, (LocalPlayer)container.getExecuter().getOriginal());
        } else {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get())).booleanValue()) {
                if (container.getStack() < 3) {
                    this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get(), (Object)container.getStack());
                }
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get(), (Object)false, serverPlayer);
            }
            if (container.getStack() > (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get())) {
                serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.PLAY_SOUND.get(), (Object)false, serverPlayer);
            }
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.LAST_STACK.get(), (Object)container.getStack());
            if (!serverPlayer.m_20096_()) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_JUMP_HEAVY.get(), (Object)true, serverPlayer);
            } else if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_JUMP_HEAVY.get())).booleanValue()) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_JUMP_HEAVY.get(), (Object)false, serverPlayer);
            }
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) - 1, 0), serverPlayer);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) - 1, 0), serverPlayer);
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) - 1, 0), serverPlayer);
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.DERIVE_TIMER.get()) <= 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_FIRST_DERIVE.get(), (Object)false, serverPlayer);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_DERIVE.get(), (Object)false, serverPlayer);
            }
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                if (!WukongWeaponCategories.isWeaponValid(serverPlayerPatch)) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    this.setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                    this.setStackSynchronize(serverPlayerPatch, 0);
                    return;
                }
                if (container.getStack() < 3) {
                    this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
                }
                if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.KEY_PRESSING.get())).booleanValue()) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.PROTECT_NEXT_FALL.get(), (Object)true);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_ATTACK_4.get(), 2.0f, 2.0f);
                    serverPlayerPatch.playAnimationSynchronized(this.animations[container.getStack()].get(), 0.0f);
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get(), (Object)container.getStack(), serverPlayer);
                    this.resetConsumption(container, serverPlayerPatch, true);
                }
            }
            if (container.getStack() < 1 && (double)container.getResource() > (double)container.getMaxResource() * 0.3) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 2 && (double)container.getResource() > (double)container.getMaxResource() * 0.5) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 3 && (double)container.getResource() > (double)container.getMaxResource() * 0.7) {
                this.breakProgress(serverPlayerPatch, container);
            }
            int current = (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CHARGED4_TIMER.get());
            if (current > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CHARGED4_TIMER.get(), (Object)(current - 1), serverPlayer);
            }
            float consumption = ((Double)Config.CHARGING_SPEED.get()).floatValue() / 5.0f;
            if (current == 1 && container.isFull()) {
                this.setStackSynchronize(serverPlayerPatch, 3);
                this.setConsumptionSynchronize(serverPlayerPatch, container.getMaxResource() - consumption);
            }
            if (current == 0 && container.getStack() >= 3 && (double)container.getResource() > (double)consumption + 0.1) {
                this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() - consumption);
            }
        }
    }

    public void breakProgress(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        this.setConsumptionSynchronize(serverPlayerPatch, 0.1f);
        this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        int star;
        int stack = container.getStack();
        int style = container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()).universalOrdinal() - WukongStyles.SMASH.universalOrdinal();
        float cooldownRatio = !container.isFull() && !container.isActivated() ? container.getResource(1.0f) : 1.0f;
        int progress = (int)Math.ceil(cooldownRatio * 40.0f);
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation progressTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/progress/" + progress + ".png");
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stance/" + style + (stack == 4 ? "_1" : "_0") + ".png");
        ResourceLocation stackBgTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/ui" + stack + ".png");
        ResourceLocation stackTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/stack" + stack + ".png");
        ResourceLocation goldenLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/gold.png");
        ResourceLocation whiteLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/white.png");
        ResourceLocation redLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/red.png");
        guiGraphics.m_280411_(progressTexture, pos.x - 12, pos.y - 12, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
        this.drawTexture(guiGraphics, styleTexture, pos.x - 12, pos.y - 12);
        this.drawTexture(guiGraphics, stackBgTexture, pos.x - 12, pos.y - 12);
        Vec2i light1 = new Vec2i(pos.x - 14, pos.y + 3);
        Vec2i light2 = new Vec2i(pos.x - 5, pos.y + 1);
        Vec2i light3 = new Vec2i(pos.x + 4, pos.y - 5);
        List<Vec2i> lightList = List.of(light1, light2, light3);
        if (container.isFull()) {
            for (Vec2i lightPos : lightList) {
                this.drawTexture(guiGraphics, goldenLightTexture, lightPos.x, lightPos.y);
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) > 0 && (star = Math.min((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get()), 3)) > 0) {
            for (int i = 0; i < star; ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, redLightTexture, lightPos.x, lightPos.y);
            }
        }
        if (stack > 0) {
            for (int i = 0; i < Math.min(stack, 3); ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, whiteLightTexture, lightPos.x, lightPos.y);
            }
            this.drawTexture(guiGraphics, stackTexture, pos.x - 12, pos.y - 12);
        }
    }

    public void drawTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        guiGraphics.m_280411_(texture, x, y, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    public static class Builder
    extends Skill.Builder<SmashHeavyAttack> {
        protected StaticAnimationProvider[] animationProviders;
        protected StaticAnimationProvider derive1;
        protected StaticAnimationProvider derive2;
        protected StaticAnimationProvider derive3;
        protected StaticAnimationProvider jumpAttackHeavy;
        StaticAnimationProvider chargingAnimation;
        StaticAnimationProvider pre;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setChargingAnimation(StaticAnimationProvider chargingAnimation) {
            this.chargingAnimation = chargingAnimation;
            return this;
        }

        public Builder setChargePreAnimation(StaticAnimationProvider pre) {
            this.pre = pre;
            return this;
        }

        public Builder setHeavyAttacks(StaticAnimationProvider ... animationProviders) {
            this.animationProviders = animationProviders;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider derive1, StaticAnimationProvider derive2, StaticAnimationProvider derive3) {
            this.derive1 = derive1;
            this.derive2 = derive2;
            this.derive3 = derive3;
            return this;
        }

        public Builder setJumpAttackHeavy(StaticAnimationProvider jumpAttackHeavy) {
            this.jumpAttackHeavy = jumpAttackHeavy;
            return this;
        }
    }
}

