/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.p1nero.wukong.Config;
import com.p1nero.wukong.capability.WKCapabilityProvider;
import com.p1nero.wukong.client.keymapping.WukongKeyMappings;
import com.p1nero.wukong.epicfight.animation.WukongAnimations;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.WukongSkills;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import com.p1nero.wukong.network.PacketHandler;
import com.p1nero.wukong.network.PacketRelay;
import com.p1nero.wukong.network.packet.server.PlayStaffFlowerPacket;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StaffPassive
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a05b-0242ac191981");

    public StaffPassive(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        Skill dodge = container.getExecuter().getSkill((SkillSlot)SkillSlots.DODGE).getSkill();
        if (dodge != WukongSkills.WUKONG_DODGE) {
            container.getExecuter().getSkill((SkillSlot)SkillSlots.DODGE).setSkill(WukongSkills.WUKONG_DODGE);
            ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> wkPlayer.setLastDodgeSkill(dodge == null ? "" : dodge.toString()));
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && WukongKeyMappings.STAFF_FLOWER.m_90857_()) {
                Input input = event.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108572_ = false;
                input.f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_276093_(DamageTypes.f_268450_) && ((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.STAFF_AUTO4)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.PLAYING_STAFF_SPIN.get())).booleanValue() && (StaffPassive.canBeBlocked(((DamageSource)event.getDamageSource()).m_7640_()) || ((DamageSource)event.getDamageSource()).m_276093_(DamageTypes.f_268534_))) {
                Entity directEntity;
                LivingEntityPatch entityPatch;
                if (!this.isBlocked((DamageSource)event.getDamageSource(), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal())) {
                    return;
                }
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.BLOCKED);
                LivingEntityPatch attackerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
                if (attackerPatch != null) {
                    attackerPatch.setLastAttackEntity(((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
                if ((entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)(directEntity = ((DamageSource)event.getDamageSource()).m_7640_()), LivingEntityPatch.class)) != null) {
                    entityPatch.onAttackBlocked((DamageSource)event.getDamageSource(), (LivingEntityPatch)event.getPlayerPatch());
                }
                StaffPassive.showBlockedEffect((ServerPlayerPatch)event.getPlayerPatch(), ((DamageSource)event.getDamageSource()).m_7640_());
                SkillContainer skillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                Skill skill = skillContainer.getSkill();
                if (skill != null) {
                    skillContainer.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), skillContainer.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, dealtDamageEvent -> {
            SkillContainer skillContainer;
            Skill skill;
            StaticAnimation animation = dealtDamageEvent.getDamageSource().getAnimation();
            if ((animation.equals((Object)WukongAnimations.STAFF_SPIN_ONE_HAND_LOOP) || animation.equals((Object)WukongAnimations.STAFF_SPIN_TWO_HAND_LOOP)) && (skill = (skillContainer = ((ServerPlayerPatch)dealtDamageEvent.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)).getSkill()) != null) {
                skillContainer.getSkill().setConsumptionSynchronize((ServerPlayerPatch)dealtDamageEvent.getPlayerPatch(), skillContainer.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue() * 3.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            PlayerPatch executer = event.getPlayerPatch();
            Skill ordinalSkill = event.getSkillContainer().getSkill();
            if (!ordinalSkill.getCategory().equals(SkillCategories.DODGE) || ordinalSkill.equals(WukongSkills.WUKONG_DODGE)) {
                return;
            }
            int dodgeId = event.getSkillContainer().getSlotId();
            if (executer.isLogicalClient() && !ordinalSkill.equals(WukongSkills.WUKONG_DODGE) && executer.hasStamina(this.getConsumption())) {
                executer.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(WukongSkills.WUKONG_DODGE);
                EpicFightNetworkManager.sendToServer((Object)new CPChangeSkill(dodgeId, -1, WukongSkills.WUKONG_DODGE.toString(), false));
                executer.getSkill((SkillSlot)SkillSlots.DODGE).sendExecuteRequest((LocalPlayerPatch)executer, ClientEngine.getInstance().controllEngine);
                ((Player)executer.getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
                    wkPlayer.setLastDodgeSkill(ordinalSkill.toString());
                    PacketRelay.syncPlayer((LocalPlayer)executer.getOriginal());
                });
                event.setCanceled(true);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        if (!container.getExecuter().isLogicalClient()) {
            PacketRelay.syncPlayer((ServerPlayer)container.getExecuter().getOriginal());
        }
        ((Player)container.getExecuter().getOriginal()).getCapability(WKCapabilityProvider.WK_PLAYER).ifPresent(wkPlayer -> {
            if (wkPlayer.getLastDodgeSkill().isEmpty()) {
                container.getExecuter().getSkill((SkillSlot)SkillSlots.DODGE).setSkill(null);
            } else {
                container.getExecuter().getSkill((SkillSlot)SkillSlots.DODGE).setSkill(SkillManager.getSkill((String)wkPlayer.getLastDodgeSkill()));
            }
        });
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
    }

    public static boolean canBeBlocked(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (Config.entities_can_be_blocked.isEmpty()) {
            Config.entities_can_be_blocked = ((List)Config.ENTITIES_CAN_BE_BLOCKED_BY_STAFF_FLOWER.get()).stream().map(entityName -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityName))).collect(Collectors.toSet());
        }
        return Config.entities_can_be_blocked.contains(entity.m_6095_());
    }

    private boolean isBlocked(DamageSource damageSource, ServerPlayer player) {
        Vec3 sourceLocation = damageSource.m_7270_();
        if (sourceLocation != null) {
            Vec3 viewVector = player.m_20252_(1.0f);
            Vec3 toSourceLocation = sourceLocation.m_82546_(player.m_20182_()).m_82541_();
            return toSourceLocation.m_82526_(viewVector) > 0.0;
        }
        return false;
    }

    public static void showBlockedEffect(ServerPlayerPatch playerPatch, Entity directEntity) {
        playerPatch.playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
        ServerPlayer serverPlayer = (ServerPlayer)playerPatch.getOriginal();
        ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument(serverPlayer.m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverPlayer, directEntity);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!(container.getExecuter().isLogicalClient() && WukongWeaponCategories.isWeaponValid(container.getExecuter()) && container.getExecuter().isBattleMode() && ((Player)container.getExecuter().getOriginal()).m_20096_())) {
            return;
        }
        if (WukongKeyMappings.STAFF_FLOWER.m_90857_() && container.getExecuter().hasStamina(((Double)Config.STAFF_FLOWER_STAMINA_CONSUME.get()).floatValue()) && !((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.PLAYING_STAFF_SPIN.get())).booleanValue() && Minecraft.m_91087_().f_91074_ != null) {
            PacketRelay.sendToServer(PacketHandler.INSTANCE, new PlayStaffFlowerPacket(WukongKeyMappings.W.m_90857_()));
            container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.PLAYING_STAFF_SPIN.get(), (Object)true, (LocalPlayer)container.getExecuter().getOriginal());
        }
    }
}

