/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.p1nero.wukong.epicfight.WukongSkillCategories;
import com.p1nero.wukong.epicfight.WukongStyles;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.WukongSkills;
import com.p1nero.wukong.epicfight.skill.custom.wukong.GreatSageHeavyAttack;
import com.p1nero.wukong.epicfight.skill.custom.wukong.PillarHeavyAttack;
import com.p1nero.wukong.epicfight.skill.custom.wukong.SmashHeavyAttack;
import com.p1nero.wukong.epicfight.skill.custom.wukong.ThrustHeavyAttack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;

public class StaffStance
extends Skill {
    public final WukongStyles style;

    public StaffStance(Builder builder) {
        super((Skill.Builder)builder);
        this.style = builder.style;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        Entity entity = container.getExecuter().getOriginal();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (container.getSkill() instanceof PillarHeavyAttack) {
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.PILLAR.ordinal());
            } else if (container.getSkill() instanceof SmashHeavyAttack) {
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.SMASH.ordinal());
            } else if (container.getSkill() instanceof ThrustHeavyAttack) {
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.THRUST.ordinal());
            } else if (container.getSkill() instanceof GreatSageHeavyAttack) {
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.GREATSAGE.ordinal());
            }
            if (!container.getDataManager().hasData((SkillDataKey)WukongSkillDataKeys.STANCE.get())) {
                String currentSkill = container.getSkill().toString();
                WukongStyles currentStyle = currentSkill.equals("wukong:pillar_style") ? WukongStyles.PILLAR : (currentSkill.equals("wukong:smash_style") ? WukongStyles.SMASH : (currentSkill.equals("wukong:thrust_style") ? WukongStyles.THRUST : (currentSkill.equals("wukong:greatsage_style") ? WukongStyles.GREATSAGE : WukongStyles.SMASH)));
                container.getDataManager().registerData((SkillDataKey)WukongSkillDataKeys.STANCE.get());
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)currentStyle.ordinal());
            }
        }
    }

    public static Builder createStaffStyle() {
        return new Builder().setCategory(WukongSkillCategories.STAFF_STYLE).setResource(Skill.Resource.NONE);
    }

    public void onRemoved(SkillContainer container) {
        WukongStyles currentStyle;
        super.onRemoved(container);
        String currentSkill = container.getSkill().toString();
        if (currentSkill.equals("wukong:pillar_style")) {
            currentStyle = WukongStyles.PILLAR;
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.PILLAR.ordinal());
        } else if (currentSkill.equals("wukong:smash_style")) {
            currentStyle = WukongStyles.SMASH;
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.SMASH.ordinal());
        } else if (currentSkill.equals("wukong:thrust_style")) {
            currentStyle = WukongStyles.THRUST;
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.THRUST.ordinal());
        } else if (currentSkill.equals("wukong:greatsage_style")) {
            currentStyle = WukongStyles.GREATSAGE;
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.GREATSAGE.ordinal());
        } else {
            currentStyle = WukongStyles.SMASH;
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.SMASH.ordinal());
        }
        container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)currentStyle.ordinal());
    }

    public WukongStyles getStyle(SkillContainer container) {
        Skill currentSkill;
        Integer stanceValue;
        if (!container.getDataManager().hasData((SkillDataKey)WukongSkillDataKeys.STANCE.get())) {
            container.getDataManager().registerData((SkillDataKey)WukongSkillDataKeys.STANCE.get());
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.STANCE.get(), (Object)WukongStyles.SMASH.ordinal());
        }
        if ((stanceValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.STANCE.get())) == null) {
            stanceValue = WukongStyles.SMASH.ordinal();
        }
        if ((currentSkill = container.getSkill()) != null) {
            if (currentSkill.equals(WukongSkills.PILLAR_STYLE)) {
                stanceValue = WukongStyles.PILLAR.ordinal();
            } else if (currentSkill.equals(WukongSkills.THRUST_STYLE)) {
                stanceValue = WukongStyles.THRUST.ordinal();
            } else if (currentSkill.equals(WukongSkills.SMASH_STYLE)) {
                stanceValue = WukongStyles.SMASH.ordinal();
            } else if (currentSkill.equals(WukongSkills.GREATSAGE_STYLE)) {
                stanceValue = WukongStyles.GREATSAGE.ordinal();
            }
        }
        WukongStyles style = WukongStyles.values()[stanceValue];
        return style;
    }

    public static class Builder
    extends Skill.Builder<StaffStance> {
        protected WukongStyles style;

        public Builder setStyle(WukongStyles style) {
            this.style = style;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

