/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.mojang.blaze3d.platform.Window;
import com.p1nero.wukong.Config;
import com.p1nero.wukong.WukongMoveset;
import com.p1nero.wukong.capability.entity.FakeWukongEntityPatch;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.WukongStyles;
import com.p1nero.wukong.epicfight.animation.WukongAnimations;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.epicfight.skill.custom.avatar.FakeWukongEntityRegistry;
import com.p1nero.wukong.epicfight.skill.custom.avatar.HeavyAttack;
import com.p1nero.wukong.epicfight.weapon.WukongWeaponCategories;
import com.p1nero.wukong.network.PacketHandler;
import com.p1nero.wukong.network.PacketRelay;
import com.p1nero.wukong.network.packet.client.AddEntityAfterImageParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ThrustHeavyAttack
extends WeaponInnateSkill
implements HeavyAttack {
    private static final UUID EVENT_UUID = UUID.fromString("d2d057cc-f30f-11ed-a02b-0242ac114515");
    @NotNull
    protected final StaticAnimationProvider[] animations;
    @NotNull
    protected StaticAnimationProvider xuli_start;
    protected StaticAnimationProvider stepinch;
    protected StaticAnimationProvider footage;
    protected StaticAnimationProvider fengchuanhua;
    protected StaticAnimationProvider chargePre;
    protected StaticAnimationProvider juesick_start;
    protected StaticAnimationProvider juesick_loop;
    protected StaticAnimationProvider juesick_end;
    protected StaticAnimationProvider jumpAttackHeavy;

    @Override
    public List<StaticAnimationProvider> getHeavyAttacks() {
        ArrayList<StaticAnimationProvider> staticAnimations = new ArrayList<StaticAnimationProvider>(List.of(this.animations));
        staticAnimations.add(this.footage);
        staticAnimations.add(this.fengchuanhua);
        return staticAnimations;
    }

    public static Builder createChargedAttack() {
        return new Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.NONE);
    }

    public ThrustHeavyAttack(Builder builder) {
        super((Skill.Builder)builder);
        this.chargePre = builder.pre;
        this.xuli_start = builder.start;
        this.animations = builder.animationProviders;
        this.stepinch = builder.stepinch;
        this.fengchuanhua = builder.fengchuanhua;
        this.footage = builder.footage;
        this.juesick_start = builder.juesick_start;
        this.juesick_loop = builder.juesick_loop;
        this.juesick_end = builder.juesick_end;
        this.jumpAttackHeavy = builder.jumpAttackHeavy;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillContainer container = executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        SkillDataManager dataManager = container.getDataManager();
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get()) > 0) {
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get(), (Object)0);
            executer.playAnimationSynchronized(this.stepinch.get(), 0.0f);
        } else if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get()) > 0) {
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.THRUST_METERS_BACK.get(), (Object)true, player);
        } else if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
            executer.playAnimationSynchronized(this.xuli_start.get(), 0.2f);
        }
        super.executeOnServer(executer, args);
    }

    public void wuKongFengShenZhiLl(ServerPlayer player, StaticAnimation animation) {
        List<Integer> summonedIds = FakeWukongEntityRegistry.getFakeWukongEntityIds(player);
        for (Integer id : summonedIds) {
            ServerLevel serverLevel = (ServerLevel)player.m_9236_();
            Entity entity = serverLevel.m_6815_(id.intValue());
            if (entity == null) {
                FakeWukongEntityRegistry.clearFakeWukongEntityIdsIfNotExist(player, id);
                continue;
            }
            FakeWukongEntityPatch patch = (FakeWukongEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, FakeWukongEntityPatch.class);
            if (patch == null) continue;
            patch.playAnimationSynchronized(animation, 0.0f);
        }
    }

    public void onInitiate(SkillContainer container) {
        SkillDataManager dataManager = container.getDataManager();
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            Input input;
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_()) {
                input = event.getMovementInput();
                input.f_108572_ = false;
            }
            if (((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() && EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_()) {
                input = event.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108572_ = false;
                input.f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)event.getPlayerPatch();
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.THRUST_JUESICK_LOOP.get()) && container.getStack() < 4) {
                container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue() * 3.0f);
            }
            if ((double)event.getAttackDamage() > 0.0) {
                this.modifyStamina((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), 2.0f);
                if (((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.PILLAR_HEAVY_FENGYUNZHUAN.get())) {
                    this.createRepelForAttackTarget(player, (Entity)((LivingAttackEvent)event.getForgeEvent()).getEntity(), 2.0);
                } else if (((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.THRUST_FOOTAGE.get())) {
                    this.createRepelForAttackTarget(player, (Entity)((LivingAttackEvent)event.getForgeEvent()).getEntity(), 1.0);
                } else if (((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null).getAnimation().equals(WukongAnimations.THRUST_CHARGED3.get())) {
                    this.createRepelForAttackTarget(player, (Entity)((LivingAttackEvent)event.getForgeEvent()).getEntity(), 1.5);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)event.getPlayerPatch();
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)player.m_21205_());
            if (!WukongWeaponCategories.isWeaponValid(event.getPlayerPatch())) {
                return;
            }
            List autoAnimations = capabilityItem.getAutoAttckMotion(event.getPlayerPatch());
            for (int i = 0; i < autoAnimations.size(); ++i) {
                if (!((AnimationProvider)autoAnimations.get(i)).get().equals((Object)event.getAnimation()) || i >= 6) continue;
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get(), (Object)30, player);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_CAN_SECOND_DERIVE.get(), (Object)false, player);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_STEOP_BACK.get(), (Object)false, player);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.THRUST_METERS_BACK.get(), (Object)false, player);
                container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_DERIVE_TIMER_TWO.get(), (Object)0, player);
                return;
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            float damageReduce;
            EpicFightDamageSource epicFightDamageSource;
            Object patt12347$temp = event.getDamageSource();
            if (patt12347$temp instanceof EpicFightDamageSource && (epicFightDamageSource = (EpicFightDamageSource)patt12347$temp).m_269533_(EpicFightDamageType.PARTIAL_DAMAGE)) {
                return;
            }
            WukongMoveset.LOGGER.info("\u84c4\u529b\u9738\u4f53: {}", container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get()));
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue() && (damageReduce = 0.2f) > 0.0f) {
                Object patt12858$temp = event.getDamageSource();
                if (patt12858$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicFightDamageSource2 = (EpicFightDamageSource)patt12858$temp;
                    epicFightDamageSource2.setStunType(StunType.NONE);
                }
                event.setAmount(event.getAmount() * (1.0f - damageReduce));
                LivingEntityPatch attackerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class);
                this.processDamage(event.getPlayerPatch(), (DamageSource)event.getDamageSource(), AttackResult.ResultType.SUCCESS, (1.0f - damageReduce) * event.getAmount(), attackerPatch);
                event.setResult(AttackResult.ResultType.MISSED);
                event.setCanceled(true);
                return;
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_STEOP_BACK.get())).booleanValue()) {
                container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue() * 90.0f);
                PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddEntityAfterImageParticle(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_19879_()));
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)WuKongSounds.PERFECT_DODGE.get(), 0.5f, 0.0f, 0.0f);
                this.modifyStamina((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), 5.0f);
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
            container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.Thrust_STEOP_BACK.get(), (Object)false);
        });
        super.onInitiate(container);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }

    public void createRepelForAttackTarget(ServerPlayer player, Entity target, double knockbackStrength) {
        Vec3 playerPos = player.m_20182_();
        if (target instanceof LivingEntity) {
            Vec3 targetPos = target.m_20182_();
            double deltaX = targetPos.f_82479_ - playerPos.f_82479_;
            double deltaZ = targetPos.f_82481_ - playerPos.f_82481_;
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (distance > 0.1) {
                target.m_5997_((deltaX /= distance) * knockbackStrength, 0.0, (deltaZ /= distance) * knockbackStrength);
                target.m_20254_(10);
            }
        }
    }

    public void modifyStamina(LivingEntity livingentity, float staminaChange) {
        float currentStamina = ((Float)livingentity.m_20088_().m_135370_(PlayerPatch.STAMINA)).floatValue();
        float newStamina = Math.max(0.0f, currentStamina + staminaChange);
        livingentity.m_20088_().m_135381_(PlayerPatch.STAMINA, (Object)Float.valueOf(newStamina));
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        if (container.getExecuter().isLogicalClient()) {
            boolean isKeyDown = EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90857_();
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_KEY_PRESSING.get(), (Object)isKeyDown, (LocalPlayer)container.getExecuter().getOriginal());
        } else {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get())).booleanValue()) {
                if (container.getStack() < 3) {
                    this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                    dataManager.setData((SkillDataKey)WukongSkillDataKeys.Thrust_LAST_STACK.get(), (Object)container.getStack());
                }
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.ADD_BEANS.get(), (Object)false, serverPlayer);
            }
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.THRUST_FASHU_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.THRUST_FASHU_TIMER.get()) - 1), serverPlayer);
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get()) != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get()) - 1), serverPlayer);
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.REPEATING_DERIVE_TIMER.get()) != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.REPEATING_DERIVE_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.REPEATING_DERIVE_TIMER.get()) - 1), serverPlayer);
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get()) != 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get(), (Object)((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get()) - 1), serverPlayer);
            }
            if (container.getStack() > (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_LAST_STACK.get())) {
                serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL.get(container.getStack() - 1).get(), 1.0f, 1.0f);
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_PLAY_SOUND.get(), (Object)false, serverPlayer);
                if (container.getStack() != 3 && ((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_KEY_PRESSING.get())).booleanValue()) {
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_LEVEL_RISE03.get(), 2.0f, 2.0f);
                }
            }
            dataManager.setData((SkillDataKey)WukongSkillDataKeys.Thrust_LAST_STACK.get(), (Object)container.getStack());
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)Math.max((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) - 1, 0), serverPlayer);
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get())).booleanValue()) {
                if (!WukongWeaponCategories.isWeaponValid(serverPlayerPatch)) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    this.setConsumptionSynchronize(serverPlayerPatch, 1.0f);
                    this.setStackSynchronize(serverPlayerPatch, 0);
                    return;
                }
                if (container.getStack() < 3) {
                    this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue());
                }
                if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_KEY_PRESSING.get())).booleanValue()) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_CHARGING.get(), (Object)false, serverPlayer);
                    serverPlayerPatch.playSound((SoundEvent)WuKongSounds.XULI_ATTACK_4.get(), 2.0f, 2.0f);
                    serverPlayerPatch.playAnimationSynchronized(this.animations[container.getStack()].get(), 0.0f);
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get(), (Object)container.getStack(), serverPlayer);
                    this.resetConsumption(container, serverPlayerPatch);
                }
            }
            if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get()) > 0) {
                if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_ATTACK_KEY_DOWN.get())).booleanValue()) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get(), (Object)0, serverPlayer);
                    if ((Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.REPEATING_DERIVE_TIMER.get()) > 0 && !((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_REPEATING_DERIVE.get())).booleanValue() && ((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_ATTACK_KEY_DOWN.get())).booleanValue()) {
                        serverPlayerPatch.playAnimationSynchronized(this.juesick_start.get(), 0.15f);
                        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_REPEATING_DERIVE.get(), (Object)true, serverPlayer);
                        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.REPEATING_DERIVE_TIMER.get(), (Object)0, serverPlayer);
                    }
                } else if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.THRUST_METERS_BACK.get())).booleanValue()) {
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.CAN_SECOND_TIMER.get(), (Object)0, serverPlayer);
                    if (container.getStack() > 0) {
                        serverPlayerPatch.playAnimationSynchronized(this.footage.get(), 0.0f);
                        this.setStackSynchronize(serverPlayerPatch, container.getStack() - 1);
                    } else {
                        serverPlayerPatch.playAnimationSynchronized(this.animations[0].get(), 0.0f);
                    }
                }
            }
            if (((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_REPEATING_DERIVE.get())).booleanValue()) {
                if (!serverPlayer.m_7500_() && !serverPlayerPatch.hasStamina(0.1f)) {
                    serverPlayerPatch.playAnimationSynchronized(this.juesick_end.get(), 0.0f);
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_REPEATING_DERIVE.get(), (Object)false, serverPlayer);
                }
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_RETREAT_TIMER.get(), (Object)30, serverPlayer);
                if (!((Boolean)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.IS_ATTACK_KEY_DOWN.get())).booleanValue()) {
                    serverPlayerPatch.playAnimationSynchronized(this.juesick_end.get(), 0.0f);
                    dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.IS_REPEATING_DERIVE.get(), (Object)false, serverPlayer);
                }
            }
            if (container.getStack() < 1 && (double)container.getResource() > (double)container.getMaxResource() * 0.3) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 2 && (double)container.getResource() > (double)container.getMaxResource() * 0.5) {
                this.breakProgress(serverPlayerPatch, container);
            } else if (container.getStack() < 3 && (double)container.getResource() > (double)container.getMaxResource() * 0.7) {
                this.breakProgress(serverPlayerPatch, container);
            }
            int current = (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.Thrust_CHARGED4_TIMER.get());
            if (current > 0) {
                dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_CHARGED4_TIMER.get(), (Object)(current - 1), serverPlayer);
            }
            float consumption = ((Double)Config.CHARGING_SPEED.get()).floatValue() / 5.0f;
            if (current == 1 && container.isFull()) {
                this.setStackSynchronize(serverPlayerPatch, 3);
                this.setConsumptionSynchronize(serverPlayerPatch, container.getMaxResource() - consumption);
            }
            if (current == 0 && container.getStack() >= 3 && (double)container.getResource() > (double)consumption + 0.1) {
                this.setConsumptionSynchronize(serverPlayerPatch, container.getResource() - consumption);
            }
        }
    }

    public void breakProgress(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        this.setConsumptionSynchronize(serverPlayerPatch, 0.1f);
        this.setStackSynchronize(serverPlayerPatch, container.getStack() + 1);
    }

    public void processDamage(PlayerPatch<?> playerPatch, DamageSource damageSource, AttackResult.ResultType attackResult, float amount, @Nullable LivingEntityPatch<?> attackerPatch) {
        EpicFightDamageSource epicFightDamageSource;
        AttackResult result;
        AttackResult attackResult2 = result = playerPatch != null ? AttackResult.of((AttackResult.ResultType)attackResult, (float)amount) : AttackResult.success((float)amount);
        if (attackerPatch != null) {
            attackerPatch.setLastAttackResult(result);
        }
        EpicFightDamageSource deflictedDamage = damageSource instanceof EpicFightDamageSource ? (epicFightDamageSource = (EpicFightDamageSource)damageSource) : EpicFightDamageSources.copy((DamageSource)damageSource);
        deflictedDamage.addRuntimeTag(EpicFightDamageType.PARTIAL_DAMAGE);
        if (playerPatch != null) {
            ((Player)playerPatch.getOriginal()).m_6469_((DamageSource)deflictedDamage, result.damage);
        }
    }

    private void resetConsumption(SkillContainer container, ServerPlayerPatch executer) {
        if (container.getStack() > 0) {
            int cnt = container.getStack();
            new Thread(() -> {
                for (int i = 0; i < cnt; ++i) {
                    executer.playSound((SoundEvent)WuKongSounds.stackSounds.get(i).get(), 1.0f, 1.0f);
                    try {
                        Thread.sleep(300L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }).start();
        } else {
            container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.Thrust_PLAY_SOUND.get(), (Object)true, (ServerPlayer)executer.getOriginal());
        }
        container.getDataManager().setDataSync((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get(), (Object)((Double)Config.DERIVE_CHECK_TIME.get()).intValue(), (ServerPlayer)executer.getOriginal());
        this.setStackSynchronize(executer, 0);
        this.setConsumptionSynchronize(executer, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return WukongWeaponCategories.isWeaponValid(container.getExecuter());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        int star;
        int stack = container.getStack();
        int style = container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()).universalOrdinal() - WukongStyles.SMASH.universalOrdinal();
        float cooldownRatio = !container.isFull() && !container.isActivated() ? container.getResource(1.0f) : 1.0f;
        int progress = (int)Math.ceil(cooldownRatio * 40.0f);
        EpicFightOptions config = EpicFightMod.CLIENT_CONFIGS;
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        Vec2i pos = config.getWeaponInnatePosition(width, height);
        ResourceLocation progressTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/progress/" + progress + ".png");
        ResourceLocation styleTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stance/" + style + (stack == 4 ? "_1" : "_0") + ".png");
        ResourceLocation stackBgTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/ui" + stack + ".png");
        ResourceLocation stackTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/stack/stack" + stack + ".png");
        ResourceLocation goldenLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/gold.png");
        ResourceLocation whiteLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/white.png");
        ResourceLocation redLightTexture = new ResourceLocation("wukong", "textures/gui/staff_stack/light/red.png");
        guiGraphics.m_280411_(progressTexture, pos.x - 12, pos.y - 12, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
        this.drawTexture(guiGraphics, styleTexture, pos.x - 12, pos.y - 12);
        this.drawTexture(guiGraphics, stackBgTexture, pos.x - 12, pos.y - 12);
        Vec2i light1 = new Vec2i(pos.x - 14, pos.y + 3);
        Vec2i light2 = new Vec2i(pos.x - 5, pos.y + 1);
        Vec2i light3 = new Vec2i(pos.x + 4, pos.y - 5);
        List<Vec2i> lightList = List.of(light1, light2, light3);
        if (container.isFull()) {
            for (Vec2i lightPos : lightList) {
                this.drawTexture(guiGraphics, goldenLightTexture, lightPos.x, lightPos.y);
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.RED_TIMER.get()) > 0 && (star = Math.min((Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.STARS_CONSUMED.get()), 3)) > 0) {
            for (int i = 0; i < star; ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, redLightTexture, lightPos.x, lightPos.y);
            }
        }
        if (stack > 0) {
            for (int i = 0; i < Math.min(stack, 3); ++i) {
                Vec2i lightPos = lightList.get(i);
                this.drawTexture(guiGraphics, whiteLightTexture, lightPos.x, lightPos.y);
            }
            this.drawTexture(guiGraphics, stackTexture, pos.x - 12, pos.y - 12);
        }
    }

    public void drawTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        guiGraphics.m_280411_(texture, x, y, 48, 48, 0.0f, 0.0f, 2, 2, 2, 2);
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return null;
    }

    public static class Builder
    extends Skill.Builder<ThrustHeavyAttack> {
        protected StaticAnimationProvider[] animationProviders;
        protected StaticAnimationProvider stepinch;
        protected StaticAnimationProvider footage;
        protected StaticAnimationProvider fengchuanhua;
        protected StaticAnimationProvider jumpAttackHeavy;
        protected StaticAnimationProvider juesick_start;
        protected StaticAnimationProvider juesick_loop;
        protected StaticAnimationProvider juesick_end;
        StaticAnimationProvider chargingAnimation;
        protected StaticAnimationProvider start;
        StaticAnimationProvider pre;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setChargingAnimation(StaticAnimationProvider chargingAnimation) {
            this.chargingAnimation = chargingAnimation;
            return this;
        }

        public Builder setChargePreAnimation(StaticAnimationProvider pre) {
            this.pre = pre;
            return this;
        }

        public Builder setDeriveAnimations(StaticAnimationProvider stepinch, StaticAnimationProvider footage, StaticAnimationProvider fengchuanhua, StaticAnimationProvider juesick_start, StaticAnimationProvider juesick_loop, StaticAnimationProvider juesick_end) {
            this.stepinch = stepinch;
            this.fengchuanhua = fengchuanhua;
            this.footage = footage;
            this.juesick_start = juesick_start;
            this.juesick_loop = juesick_loop;
            this.juesick_end = juesick_end;
            return this;
        }

        public Builder setHeavyAttacks(StaticAnimationProvider ... animationProviders) {
            this.animationProviders = animationProviders;
            return this;
        }

        public Builder setStartAttacks(StaticAnimationProvider start) {
            this.start = start;
            return this;
        }

        public Builder setJumpAttackHeavy(StaticAnimationProvider jumpAttackHeavy) {
            this.jumpAttackHeavy = jumpAttackHeavy;
            return this;
        }
    }
}

