/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.wukong.epicfight.skill.custom.wukong;

import com.p1nero.wukong.Config;
import com.p1nero.wukong.client.WuKongSounds;
import com.p1nero.wukong.epicfight.skill.WukongSkillDataKeys;
import com.p1nero.wukong.network.PacketHandler;
import com.p1nero.wukong.network.PacketRelay;
import com.p1nero.wukong.network.packet.client.AddEntityAfterImageParticle;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class WukongDodgeSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d011cc-f30f-11ed-a05b-0242ac114515");
    public static final int RESET_TICKS = 100;
    protected final StaticAnimationProvider[][] animations;

    public static Builder createDodgeBuilder() {
        return new Builder().setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public WukongDodgeSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.animations = builder.animations;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.DODGE_PLAYED.get())).booleanValue()) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)WuKongSounds.PERFECT_DODGE.get(), 1.0f, 1.0f);
                if (player.m_9236_() instanceof ServerLevel) {
                    PacketRelay.sendToAll(PacketHandler.INSTANCE, new AddEntityAfterImageParticle(player.m_19879_()));
                }
                SkillContainer weaponInnateContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                weaponInnateContainer.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), weaponInnateContainer.getResource() + ((Double)Config.CHARGING_SPEED.get()).floatValue() * 20.0f);
                this.modifyStamina((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), 3.0f);
                container.getDataManager().setData((SkillDataKey)WukongSkillDataKeys.DODGE_PLAYED.get(), (Object)true);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(this.animations[3][(Integer)container.getDataManager().getDataValue((SkillDataKey)WukongSkillDataKeys.DIRECTION.get())].get(), 0.0f);
            }
        });
    }

    public void modifyStamina(LivingEntity livingentity, float staminaChange) {
        float currentStamina = ((Float)livingentity.m_20088_().m_135370_(PlayerPatch.STAMINA)).floatValue();
        float newStamina = Math.max(0.0f, currentStamina + staminaChange);
        livingentity.m_20088_().m_135381_(PlayerPatch.STAMINA, (Object)Float.valueOf(newStamina));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(vertic >= 0 ? 0 : 1);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(ItemStack.f_41584_.format(this.consumption));
        return list;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        int i = args.readInt();
        float yaw = args.readFloat();
        SkillDataManager dataManager = executer.getSkill((SkillSlot)SkillSlots.DODGE).getDataManager();
        dataManager.setData((SkillDataKey)WukongSkillDataKeys.DODGE_PLAYED.get(), (Object)false);
        int count = (Integer)dataManager.getDataValue((SkillDataKey)WukongSkillDataKeys.COUNT.get());
        executer.playAnimationSynchronized(this.animations[count][i].get(), 0.0f);
        executer.playSound((SoundEvent)EpicFightSounds.ROLL.get(), 1.0f, 1.0f);
        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.DIRECTION.get(), (Object)i, (ServerPlayer)executer.getOriginal());
        if (count != 0) {
            dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get(), (Object)100, (ServerPlayer)executer.getOriginal());
            BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)executer, (SkillContainer)executer.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK), (StaticAnimation)this.animations[count][i].get(), (int)0);
        }
        dataManager.setDataSync((SkillDataKey)WukongSkillDataKeys.COUNT.get(), (Object)(++count % 3), (ServerPlayer)executer.getOriginal());
        executer.setModelYRot(yaw, true);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager manager = container.getDataManager();
        if (manager.hasData((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get()) && (Integer)manager.getDataValue((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get()) > 0) {
            manager.setData((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get(), (Object)((Integer)manager.getDataValue((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get()) - 1));
            if ((Integer)manager.getDataValue((SkillDataKey)WukongSkillDataKeys.RESET_TIMER.get()) == 1 && manager.hasData((SkillDataKey)WukongSkillDataKeys.COUNT.get())) {
                manager.setData((SkillDataKey)WukongSkillDataKeys.COUNT.get(), (Object)0);
            }
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isInAir() && playerState.canUseSkill() && !((Player)executer.getOriginal()).m_20069_() && !((Player)executer.getOriginal()).m_6147_() && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public static class Builder
    extends Skill.Builder<WukongDodgeSkill> {
        protected StaticAnimationProvider[][] animations = new StaticAnimationProvider[4][4];

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setAnimations1(StaticAnimationProvider ... animations) {
            this.animations[0] = animations;
            return this;
        }

        public Builder setAnimations2(StaticAnimationProvider ... animations) {
            this.animations[1] = animations;
            return this;
        }

        public Builder setAnimations3(StaticAnimationProvider ... animations) {
            this.animations[2] = animations;
            return this;
        }

        public Builder setPerfectAnimations(StaticAnimationProvider ... animations) {
            this.animations[3] = animations;
            return this;
        }
    }
}

